/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.Location;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;

final class LocalUtils {
    private LocalUtils() {
    }

    static IOException handleException(Location location, IOException exception) throws IOException {
        if (exception instanceof FileNotFoundException || exception instanceof NoSuchFileException) {
            throw LocalUtils.withCause(new FileNotFoundException(location.toString()), exception);
        }
        if (exception instanceof FileAlreadyExistsException) {
            throw LocalUtils.withCause(new FileAlreadyExistsException(location.toString()), exception);
        }
        throw new IOException(exception.getMessage() + ": " + String.valueOf(location), exception);
    }

    private static <T extends Throwable> T withCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }
}

