/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public record FileEntry(Location location, long length, Instant lastModified, Optional<List<Block>> blocks, Set<String> tags) {
    public FileEntry {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(blocks, "blocks is null");
        blocks = blocks.map(locations -> FileEntry.validatedBlocks(locations, length));
        tags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tags, "tags is null"));
    }

    public FileEntry(Location location, long length, Instant lastModified, Optional<List<Block>> blocks) {
        this(location, length, lastModified, blocks, (Set<String>)ImmutableSet.of());
    }

    private static List<Block> validatedBlocks(List<Block> blocks, long length) {
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (Object)"blocks is empty");
        blocks = (List)blocks.stream().sorted(Comparator.comparing(Block::offset)).collect(ImmutableList.toImmutableList());
        long position = 0L;
        for (Block block : blocks) {
            Preconditions.checkArgument((block.offset() <= position ? 1 : 0) != 0, (Object)"blocks have a gap");
            position = Math.max(position, Math.addExact(block.offset(), block.length()));
        }
        Preconditions.checkArgument((position >= length ? 1 : 0) != 0, (Object)"blocks do not cover file");
        return blocks;
    }

    public record Block(List<String> hosts, long offset, long length) {
        public Block {
            hosts = ImmutableList.copyOf((Collection)Objects.requireNonNull(hosts, "hosts is null"));
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset is negative");
            Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        }
    }
}

