/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public final class CacheInputFile
implements TrinoInputFile {
    private final TrinoInputFile delegate;
    private final TrinoFileSystemCache cache;
    private final CacheKeyProvider keyProvider;

    public CacheInputFile(TrinoInputFile delegate, TrinoFileSystemCache cache, CacheKeyProvider keyProvider) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = Objects.requireNonNull(cache, "cache is null");
        this.keyProvider = Objects.requireNonNull(keyProvider, "keyProvider is null");
    }

    @Override
    public TrinoInput newInput() throws IOException {
        Optional<String> key = this.keyProvider.getCacheKey(this.delegate);
        if (key.isPresent()) {
            return this.cache.cacheInput(this.delegate, key.orElseThrow());
        }
        return this.delegate.newInput();
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        Optional<String> key = this.keyProvider.getCacheKey(this.delegate);
        if (key.isPresent()) {
            return this.cache.cacheStream(this.delegate, key.orElseThrow());
        }
        return this.delegate.newStream();
    }

    @Override
    public long length() throws IOException {
        return this.delegate.length();
    }

    @Override
    public Instant lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    @Override
    public boolean exists() throws IOException {
        return this.delegate.exists();
    }

    @Override
    public Location location() {
        return this.delegate.location();
    }
}

