/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

class LocalFileIterator
implements FileIterator {
    private final Iterator<FileEntry> iterator;

    public LocalFileIterator(Location location, final Path rootPath, Path path) throws IOException {
        Objects.requireNonNull(rootPath, "rootPath is null");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Location is a file: " + String.valueOf(location));
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            this.iterator = Collections.emptyIterator();
        } else {
            final ImmutableList.Builder files = ImmutableList.builder();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        if (!file.startsWith(rootPath)) {
                            throw new IOException("entry is not inside of filesystem root");
                        }
                        files.add((Object)new FileEntry(Location.of("local:///" + String.valueOf(rootPath.relativize(file))), attributes.size(), attributes.lastModifiedTime().toInstant(), Optional.empty()));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                    if (e instanceof NoSuchFileException) {
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            this.iterator = files.build().iterator();
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    @Override
    public FileEntry next() throws IOException {
        return this.iterator.next();
    }
}

