/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.tracing.TracingFileSystem;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;

public final class TracingFileSystemFactory
implements TrinoFileSystemFactory {
    private final Tracer tracer;
    private final TrinoFileSystemFactory delegate;

    public TracingFileSystemFactory(Tracer tracer, TrinoFileSystemFactory delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new TracingFileSystem(this.tracer, this.delegate.create(identity));
    }

    @Override
    public TrinoFileSystem create(ConnectorSession session) {
        return new TracingFileSystem(this.tracer, this.delegate.create(session));
    }
}

