/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.Throwables;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public interface TrinoFileSystem {
    public TrinoInputFile newInputFile(Location var1);

    public TrinoInputFile newInputFile(Location var1, long var2);

    public TrinoOutputFile newOutputFile(Location var1);

    public void deleteFile(Location var1) throws IOException;

    default public void deleteFiles(Collection<Location> locations) throws IOException {
        for (Location location : locations) {
            this.deleteFile(location);
        }
    }

    public void deleteDirectory(Location var1) throws IOException;

    public void renameFile(Location var1, Location var2) throws IOException;

    public FileIterator listFiles(Location var1) throws IOException;

    public Optional<Boolean> directoryExists(Location var1) throws IOException;

    public void createDirectory(Location var1) throws IOException;

    public void renameDirectory(Location var1, Location var2) throws IOException;

    public Set<Location> listDirectories(Location var1) throws IOException;

    public Optional<Location> createTemporaryDirectory(Location var1, String var2, String var3) throws IOException;

    public static boolean isUnrecoverableException(Throwable throwable) {
        return Throwables.getCausalChain((Throwable)throwable).stream().anyMatch(t -> t instanceof TrinoFileSystemException || t instanceof FileNotFoundException);
    }
}

