/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.cache.CacheFileSystem;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.DefaultCacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystemCacheConfig;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.spi.block.TestingSession;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.TestingTelemetry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestCacheFileSystemAccessOperations {
    private TrinoFileSystemFactory tracingFileSystemFactory;
    private CacheFileSystem fileSystem;
    private final TestingTelemetry telemetry = TestingTelemetry.create((String)"cache-file-system");

    @BeforeAll
    void setUp() {
        this.tracingFileSystemFactory = new TracingFileSystemFactory(this.telemetry.getTracer(), (TrinoFileSystemFactory)new MemoryFileSystemFactory());
        MemoryFileSystemCacheConfig configuration = new MemoryFileSystemCacheConfig().setCacheTtl(new Duration(24.0, TimeUnit.HOURS));
        this.fileSystem = new CacheFileSystem(this.tracingFileSystemFactory.create(TestingSession.SESSION), (TrinoFileSystemCache)new MemoryFileSystemCache(configuration), (CacheKeyProvider)new DefaultCacheKeyProvider());
    }

    @AfterAll
    void tearDown() {
        this.tracingFileSystemFactory = null;
        this.fileSystem = null;
    }

    @Test
    void testCache() throws IOException {
        Location location = this.getRootLocation().appendPath("hello");
        byte[] content = "hello world".getBytes(StandardCharsets.UTF_8);
        try (OutputStream output = this.fileSystem.newOutputFile(location).create();){
            output.write(content);
        }
        this.assertReadOperations(location, content, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(location, "InputFile.length")).add((Object)new FileOperation(location, "InputFile.newInput")).add((Object)new FileOperation(location, "InputFile.lastModified")).build());
        this.assertReadOperations(location, content, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(location, "InputFile.length")).add((Object)new FileOperation(location, "InputFile.lastModified")).build());
        byte[] modifiedContent = "modified content".getBytes(StandardCharsets.UTF_8);
        this.fileSystem.newOutputFile(location).createOrOverwrite(modifiedContent);
        this.assertReadOperations(location, modifiedContent, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(location, "InputFile.length")).add((Object)new FileOperation(location, "InputFile.newInput")).add((Object)new FileOperation(location, "InputFile.lastModified")).build());
    }

    private Location getRootLocation() {
        return Location.of((String)"memory://");
    }

    private void assertReadOperations(Location location, byte[] content, Multiset<FileOperation> fileOperations) throws IOException {
        List spans = this.telemetry.captureSpans(() -> {
            TrinoInputFile file = this.fileSystem.newInputFile(location);
            int length = (int)file.length();
            try (TrinoInput input = file.newInput();){
                Assertions.assertThat((Comparable)input.readFully(0L, length)).isEqualTo((Object)Slices.wrappedBuffer((byte[])content));
            }
        });
        MultisetAssertions.assertMultisetsEqual(this.getOperations(spans), fileOperations);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Multiset<FileOperation> getOperations(List<SpanData> spans) {
        @Nullable HashMultiset operations = HashMultiset.create();
        for (SpanData span : spans) {
            if (!span.getName().startsWith("InputFile.")) continue;
            operations.add((Object)new FileOperation(Location.of((String)((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION))), span.getName()));
        }
        return operations;
    }

    private record FileOperation(Location path, String operationType) {
    }
}

