/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.client.NodeVersion;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProvider;
import io.trino.filesystem.cache.ConsistentHashingHostAddressProviderConfig;
import io.trino.metadata.InternalNode;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.testing.TestingNodeManager;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConsistentHashingCacheHostAddressProvider {
    @Test
    public void testConsistentHashing() {
        TestingNodeManager nodeManager = new TestingNodeManager(true);
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-1"));
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-2"));
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-3"));
        ConsistentHashingHostAddressProvider provider = new ConsistentHashingHostAddressProvider((NodeManager)nodeManager, new ConsistentHashingHostAddressProviderConfig().setPreferredHostsCount(1));
        provider.refreshHashRing();
        TestConsistentHashingCacheHostAddressProvider.assertFairDistribution((CachingHostAddressProvider)provider, nodeManager.getWorkerNodes());
        nodeManager.removeNode(TestConsistentHashingCacheHostAddressProvider.node("test-2"));
        provider.refreshHashRing();
        TestConsistentHashingCacheHostAddressProvider.assertFairDistribution((CachingHostAddressProvider)provider, nodeManager.getWorkerNodes());
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-4"));
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-5"));
        provider.refreshHashRing();
        TestConsistentHashingCacheHostAddressProvider.assertFairDistribution((CachingHostAddressProvider)provider, nodeManager.getWorkerNodes());
    }

    @Test
    public void testConsistentHashingFairRedistribution() {
        TestingNodeManager nodeManager = new TestingNodeManager(true);
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-1"));
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-2"));
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-3"));
        ConsistentHashingHostAddressProvider provider = new ConsistentHashingHostAddressProvider((NodeManager)nodeManager, new ConsistentHashingHostAddressProviderConfig().setPreferredHostsCount(1));
        provider.refreshHashRing();
        Map<String, Set<Integer>> distribution = this.getDistribution(provider);
        nodeManager.removeNode(TestConsistentHashingCacheHostAddressProvider.node("test-1"));
        provider.refreshHashRing();
        Map<String, Set<Integer>> removeOne = this.getDistribution(provider);
        this.assertMinimalRedistribution(distribution, removeOne);
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-1"));
        provider.refreshHashRing();
        Map<String, Set<Integer>> addOne = this.getDistribution(provider);
        this.assertMinimalRedistribution(removeOne, addOne);
        Assertions.assertThat(addOne).isEqualTo(distribution);
        nodeManager.addNode(TestConsistentHashingCacheHostAddressProvider.node("test-4"));
        provider.refreshHashRing();
        Map<String, Set<Integer>> addTwo = this.getDistribution(provider);
        this.assertMinimalRedistribution(addOne, addTwo);
    }

    private static void assertFairDistribution(CachingHostAddressProvider cachingHostAddressProvider, Set<Node> nodeNames) {
        int n = 1000;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (int i = 0; i < n; ++i) {
            counts.merge(((HostAddress)cachingHostAddressProvider.getHosts(String.valueOf(i), (List)ImmutableList.of()).get(0)).getHostText(), 1, Math::addExact);
        }
        Assertions.assertThat((Collection)nodeNames.stream().map(m -> m.getHostAndPort().getHostText()).collect(Collectors.toSet())).isEqualTo(counts.keySet());
        counts.values().forEach(c -> Assertions.assertThat(((double)Math.abs(c - n / nodeNames.size()) < 0.1 * (double)n ? 1 : 0) != 0).isTrue());
    }

    private void assertMinimalRedistribution(Map<String, Set<Integer>> oldDistribution, Map<String, Set<Integer>> newDistribution) {
        oldDistribution.entrySet().stream().filter(e -> newDistribution.containsKey(e.getKey())).forEach(entry -> {
            int oldKeySize;
            int sameKeySize = Sets.intersection((Set)((Set)newDistribution.get(entry.getKey())), (Set)((Set)entry.getValue())).size();
            Assertions.assertThat((Math.abs(sameKeySize - (oldKeySize = ((Set)entry.getValue()).size())) < oldKeySize / oldDistribution.size() ? 1 : 0) != 0).isTrue();
        });
    }

    private Map<String, Set<Integer>> getDistribution(ConsistentHashingHostAddressProvider provider) {
        int n = 1000;
        HashMap<String, Set<Integer>> distribution = new HashMap<String, Set<Integer>>();
        for (int i = 0; i < n; ++i) {
            String host = ((HostAddress)provider.getHosts(String.valueOf(i), (List)ImmutableList.of()).get(0)).getHostText();
            distribution.computeIfAbsent(host, k -> new HashSet()).add(i);
        }
        return distribution;
    }

    private static Node node(String nodeName) {
        return new InternalNode(nodeName, URI.create("http://" + nodeName + "/"), NodeVersion.UNKNOWN, false);
    }
}

