/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.memory.MemoryFileSystemCacheConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestMemoryFileSystemCacheConfig {
    @Test
    void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MemoryFileSystemCacheConfig)ConfigAssertions.recordDefaults(MemoryFileSystemCacheConfig.class)).setMaxSize(MemoryFileSystemCacheConfig.DEFAULT_CACHE_SIZE).setCacheTtl(new Duration(1.0, TimeUnit.HOURS)).setMaxContentLength(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"fs.memory-cache.max-size", (Object)"10MB").put((Object)"fs.memory-cache.max-content-length", (Object)"1MB").put((Object)"fs.memory-cache.ttl", (Object)"8h").buildOrThrow();
        MemoryFileSystemCacheConfig expected = new MemoryFileSystemCacheConfig().setMaxSize(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setCacheTtl(new Duration(8.0, TimeUnit.HOURS)).setMaxContentLength(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

