/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.encryption;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.UriLocation;
import io.trino.filesystem.encryption.EncryptionKey;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class EncryptionEnforcingFileSystem
implements TrinoFileSystem {
    private final TrinoFileSystem delegate;
    private final EncryptionKey key;

    public EncryptionEnforcingFileSystem(TrinoFileSystem delegate, EncryptionKey key) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.key = Objects.requireNonNull(key, "key is null");
    }

    @Override
    public TrinoInputFile newInputFile(Location location) {
        return this.newEncryptedInputFile(location, this.key);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, EncryptionKey key) {
        Preconditions.checkArgument((boolean)this.key.equals(key), (Object)"Provided key is not the same as the class encryption key");
        return this.delegate.newEncryptedInputFile(location, key);
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length) {
        return this.delegate.newEncryptedInputFile(location, length, this.key);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, long length, EncryptionKey key) {
        Preconditions.checkArgument((boolean)this.key.equals(key), (Object)"Provided key is not the same as the class encryption key");
        return this.delegate.newEncryptedInputFile(location, length, key);
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length, Instant lastModified) {
        return this.delegate.newEncryptedInputFile(location, length, lastModified, this.key);
    }

    @Override
    public TrinoInputFile newEncryptedInputFile(Location location, long length, Instant lastModified, EncryptionKey key) {
        Preconditions.checkArgument((boolean)this.key.equals(key), (Object)"Provided key is not the same as the class encryption key");
        return this.delegate.newEncryptedInputFile(location, length, key);
    }

    @Override
    public TrinoOutputFile newOutputFile(Location location) {
        return this.delegate.newEncryptedOutputFile(location, this.key);
    }

    @Override
    public TrinoOutputFile newEncryptedOutputFile(Location location, EncryptionKey key) {
        Preconditions.checkArgument((boolean)this.key.equals(key), (Object)"Provided key is not the same as the class encryption key");
        return this.delegate.newEncryptedOutputFile(location, key);
    }

    @Override
    public void deleteFile(Location location) throws IOException {
        this.delegate.deleteFile(location);
    }

    @Override
    public void deleteFiles(Collection<Location> locations) throws IOException {
        this.delegate.deleteFiles(locations);
    }

    @Override
    public void deleteDirectory(Location location) throws IOException {
        this.delegate.deleteDirectory(location);
    }

    @Override
    public void renameFile(Location source, Location target) throws IOException {
        this.delegate.renameFile(source, target);
    }

    @Override
    public FileIterator listFiles(Location location) throws IOException {
        return this.delegate.listFiles(location);
    }

    @Override
    public Optional<Boolean> directoryExists(Location location) throws IOException {
        return this.delegate.directoryExists(location);
    }

    @Override
    public void createDirectory(Location location) throws IOException {
        this.delegate.createDirectory(location);
    }

    @Override
    public void renameDirectory(Location source, Location target) throws IOException {
        this.delegate.renameDirectory(source, target);
    }

    @Override
    public Set<Location> listDirectories(Location location) throws IOException {
        return this.delegate.listDirectories(location);
    }

    @Override
    public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) throws IOException {
        return this.delegate.createTemporaryDirectory(targetPath, temporaryPrefix, relativePrefix);
    }

    @Override
    public Optional<UriLocation> preSignedUri(Location location, Duration ttl) throws IOException {
        return this.delegate.encryptedPreSignedUri(location, ttl, this.key);
    }

    @Override
    public Optional<UriLocation> encryptedPreSignedUri(Location location, Duration ttl, EncryptionKey key) throws IOException {
        Preconditions.checkArgument((boolean)this.key.equals(key), (Object)"Provided key is not the same as the class encryption key");
        return this.delegate.encryptedPreSignedUri(location, ttl, key);
    }

    public TrinoFileSystem getDelegate() {
        return this.delegate;
    }
}

