/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.memory.MemoryBlob;
import io.trino.filesystem.memory.MemoryInputFile;
import io.trino.filesystem.memory.MemoryOutputFile;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MemoryFileSystem
implements TrinoFileSystem {
    private final ConcurrentMap<String, MemoryBlob> blobs = new ConcurrentHashMap<String, MemoryBlob>();

    @VisibleForTesting
    public boolean isEmpty() {
        return this.blobs.isEmpty();
    }

    @Override
    public TrinoInputFile newInputFile(Location location) {
        String key = MemoryFileSystem.toBlobKey(location);
        return new MemoryInputFile(location, () -> (MemoryBlob)this.blobs.get(key), OptionalLong.empty(), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length) {
        String key = MemoryFileSystem.toBlobKey(location);
        return new MemoryInputFile(location, () -> (MemoryBlob)this.blobs.get(key), OptionalLong.of(length), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length, Instant lastModified) {
        String key = MemoryFileSystem.toBlobKey(location);
        return new MemoryInputFile(location, () -> (MemoryBlob)this.blobs.get(key), OptionalLong.of(length), Optional.of(lastModified));
    }

    @Override
    public TrinoOutputFile newOutputFile(final Location location) {
        final String key = MemoryFileSystem.toBlobKey(location);
        MemoryOutputFile.OutputBlob outputBlob = new MemoryOutputFile.OutputBlob(){
            final /* synthetic */ MemoryFileSystem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean exists() {
                return this.this$0.blobs.containsKey(key);
            }

            @Override
            public void createBlob(Slice data) throws FileAlreadyExistsException {
                if (this.this$0.blobs.putIfAbsent(key, new MemoryBlob(data)) != null) {
                    throw new FileAlreadyExistsException(location.toString());
                }
            }

            @Override
            public void overwriteBlob(Slice data) {
                this.this$0.blobs.put(key, new MemoryBlob(data));
            }
        };
        return new MemoryOutputFile(location, outputBlob);
    }

    @Override
    public void deleteFile(Location location) throws IOException {
        this.blobs.remove(MemoryFileSystem.toBlobKey(location));
    }

    @Override
    public void deleteDirectory(Location location) throws IOException {
        String prefix = MemoryFileSystem.toBlobPrefix(location);
        this.blobs.keySet().removeIf(path -> path.startsWith(prefix));
    }

    @Override
    public void renameFile(Location source, Location target) throws IOException {
        String sourceKey = MemoryFileSystem.toBlobKey(source);
        String targetKey = MemoryFileSystem.toBlobKey(target);
        MemoryBlob sourceData = (MemoryBlob)this.blobs.get(sourceKey);
        if (sourceData == null) {
            throw new IOException("File rename from %s to %s failed: Source does not exist".formatted(source, target));
        }
        if (this.blobs.putIfAbsent(targetKey, sourceData) != null) {
            throw new IOException("File rename from %s to %s failed: Target already exists".formatted(source, target));
        }
        this.blobs.remove(sourceKey, sourceData);
    }

    @Override
    public FileIterator listFiles(Location location) throws IOException {
        String prefix = MemoryFileSystem.toBlobPrefix(location);
        final Iterator iterator = this.blobs.entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(entry -> ((String)entry.getKey()).startsWith(prefix)).map(entry -> new FileEntry(Location.of("memory:///" + (String)entry.getKey()), ((MemoryBlob)entry.getValue()).data().length(), ((MemoryBlob)entry.getValue()).lastModified(), Optional.empty())).iterator();
        return new FileIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FileEntry next() {
                return (FileEntry)iterator.next();
            }
        };
    }

    @Override
    public Optional<Boolean> directoryExists(Location location) throws IOException {
        MemoryFileSystem.validateMemoryLocation(location);
        if (location.path().isEmpty() || this.listFiles(location).hasNext()) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    @Override
    public void createDirectory(Location location) throws IOException {
        MemoryFileSystem.validateMemoryLocation(location);
    }

    @Override
    public void renameDirectory(Location source, Location target) throws IOException {
        throw new IOException("Memory file system does not support directory renames");
    }

    @Override
    public Set<Location> listDirectories(Location location) throws IOException {
        String prefix = MemoryFileSystem.toBlobPrefix(location);
        ImmutableSet.Builder directories = ImmutableSet.builder();
        for (String key : this.blobs.keySet()) {
            int index;
            if (!key.startsWith(prefix) || (index = key.indexOf(47, prefix.length() + 1)) < 0) continue;
            directories.add((Object)Location.of("memory:///" + key.substring(0, index + 1)));
        }
        return directories.build();
    }

    @Override
    public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) {
        MemoryFileSystem.validateMemoryLocation(targetPath);
        return Optional.empty();
    }

    private static String toBlobKey(Location location) {
        MemoryFileSystem.validateMemoryLocation(location);
        location.verifyValidFileLocation();
        return location.path();
    }

    private static String toBlobPrefix(Location location) {
        MemoryFileSystem.validateMemoryLocation(location);
        Object directoryPath = location.path();
        if (!((String)directoryPath).isEmpty() && !((String)directoryPath).endsWith("/")) {
            directoryPath = (String)directoryPath + "/";
        }
        return directoryPath;
    }

    private static void validateMemoryLocation(Location location) {
        Preconditions.checkArgument((boolean)location.scheme().equals(Optional.of("memory")), (String)"Only 'memory' scheme is supported: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.userInfo().isEmpty(), (String)"Memory location cannot contain user info: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.host().isEmpty(), (String)"Memory location cannot contain a host: %s", (Object)location);
    }
}

