/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import io.trino.filesystem.Location;
import java.util.regex.Pattern;

public final class Locations {
    private static final Pattern S3_TABLES = Pattern.compile("s3://(?!.*/).*--table-s3");

    private Locations() {
    }

    @Deprecated
    public static String appendPath(String location, String path) {
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return (String)location + path;
    }

    public static boolean areDirectoryLocationsEquivalent(Location leftLocation, Location rightLocation) {
        return leftLocation.equals(rightLocation) || leftLocation.removeOneTrailingSlash().equals(rightLocation.removeOneTrailingSlash());
    }

    public static boolean isS3Tables(String location) {
        return S3_TABLES.matcher(location).matches();
    }
}

