/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.Location;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class TestFileEntry {
    private static final Location LOCATION = Location.of((String)"/test");
    private static final Instant MODIFIED = Instant.ofEpochSecond(1234567890L);

    @Test
    public void testEmptyBlocks() {
        Assertions.assertThat((Object)new FileEntry(LOCATION, 123L, MODIFIED, Optional.empty())).satisfies(new ThrowingConsumer[]{entry -> {
            Assertions.assertThat((Object)entry.location()).isEqualTo((Object)LOCATION);
            Assertions.assertThat((long)entry.length()).isEqualTo(123L);
            Assertions.assertThat((Instant)entry.lastModified()).isEqualTo((Object)MODIFIED);
            Assertions.assertThat((Optional)entry.blocks()).isEmpty();
        }});
    }

    @Test
    public void testPresentBlocks() {
        List<FileEntry.Block> locations = List.of(new FileEntry.Block(List.of(), 0L, 50L), new FileEntry.Block(List.of(), 50L, 70L), new FileEntry.Block(List.of(), 100L, 150L));
        Assertions.assertThat((Object)new FileEntry(LOCATION, 200L, MODIFIED, Optional.of(locations))).satisfies(new ThrowingConsumer[]{entry -> Assertions.assertThat((Optional)entry.blocks()).contains((Object)locations)});
    }

    @Test
    public void testMissingBlocks() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FileEntry(LOCATION, 0L, MODIFIED, Optional.of(List.of()))).isInstanceOf(IllegalArgumentException.class)).hasMessage("blocks is empty");
    }

    @Test
    public void testBlocksEmptyFile() {
        List<FileEntry.Block> locations = List.of(new FileEntry.Block(List.of(), 0L, 0L));
        Assertions.assertThat((Object)new FileEntry(LOCATION, 0L, MODIFIED, Optional.of(locations))).satisfies(new ThrowingConsumer[]{entry -> Assertions.assertThat((Optional)entry.blocks()).contains((Object)locations)});
    }

    @Test
    public void testBlocksGapAtStart() {
        List<FileEntry.Block> locations = List.of(new FileEntry.Block(List.of(), 50L, 50L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FileEntry(LOCATION, 100L, MODIFIED, Optional.of(locations))).isInstanceOf(IllegalArgumentException.class)).hasMessage("blocks have a gap");
    }

    @Test
    public void testBlocksGapInMiddle() {
        List<FileEntry.Block> locations = List.of(new FileEntry.Block(List.of(), 0L, 50L), new FileEntry.Block(List.of(), 100L, 100L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FileEntry(LOCATION, 200L, MODIFIED, Optional.of(locations))).isInstanceOf(IllegalArgumentException.class)).hasMessage("blocks have a gap");
    }

    @Test
    public void testBlocksGapAtEnd() {
        List<FileEntry.Block> locations = List.of(new FileEntry.Block(List.of(), 0L, 50L), new FileEntry.Block(List.of(), 50L, 49L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FileEntry(LOCATION, 100L, MODIFIED, Optional.of(locations))).isInstanceOf(IllegalArgumentException.class)).hasMessage("blocks do not cover file");
    }
}

