/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import io.airlift.testing.EquivalenceTester;
import io.trino.filesystem.Location;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

class TestLocation {
    TestLocation() {
    }

    @Test
    void testParse() {
        TestLocation.assertLocation("scheme://userInfo@host/some/path", "scheme", Optional.of("userInfo"), "host", "some/path");
        TestLocation.assertLocation("SCHEME://USER_INFO@HOST/SOME/PATH", "SCHEME", Optional.of("USER_INFO"), "HOST", "SOME/PATH");
        TestLocation.assertLocation("sc heme://user info@ho st/so me/pa th", Optional.of("sc heme"), Optional.of("user info"), Optional.of("ho st"), OptionalInt.empty(), "so me/pa th", Set.of("Illegal character in scheme name at index 2: sc heme://user info@ho st/so me/pa th"));
        TestLocation.assertLocation("scheme://host/some/path", "scheme", Optional.empty(), "host", "some/path");
        TestLocation.assertLocation("scheme://@host/some/path", "scheme", Optional.of(""), "host", "some/path");
        TestLocation.assertLocation("scheme:///some/path", "scheme", Optional.empty(), "", "some/path");
        TestLocation.assertLocation("scheme://user@/some/path", Optional.of("scheme"), Optional.of("user"), Optional.empty(), OptionalInt.empty(), "some/path", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[user]]"));
        TestLocation.assertLocation("scheme://host:1234/some/path//@here:444/there", Optional.of("scheme"), Optional.empty(), Optional.of("host"), OptionalInt.of(1234), "some/path//@here:444/there");
        TestLocation.assertLocation("scheme://@/some/path", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.empty(), "some/path", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]"));
        TestLocation.assertLocation("scheme://:1/some/path", Optional.of("scheme"), Optional.empty(), Optional.empty(), OptionalInt.of(1), "some/path", Set.of("port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("scheme://@:1/some/path", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.of(1), "some/path", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]", "port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("scheme://@/", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.empty(), "", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]"));
        TestLocation.assertLocation("scheme://@:1/", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.of(1), "", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]", "port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("scheme://:1/", Optional.of("scheme"), Optional.empty(), Optional.empty(), OptionalInt.of(1), "", Set.of("port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("scheme://@//", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.empty(), "/", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]"));
        TestLocation.assertLocation("scheme://@:1//", Optional.of("scheme"), Optional.of(""), Optional.empty(), OptionalInt.of(1), "/", Set.of("userInfo compared with URI: expected [Optional.empty], was [Optional[]]", "port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("scheme://:1//", Optional.of("scheme"), Optional.empty(), Optional.empty(), OptionalInt.of(1), "/", Set.of("port compared with URI: expected [OptionalInt.empty], was [OptionalInt[1]]"));
        TestLocation.assertLocation("hdfs://hadoop:9000/some/path", "hdfs", "hadoop", 9000, "some/path");
        TestLocation.assertLocation("scheme://host/..", "scheme", Optional.empty(), "host", "..");
        TestLocation.assertLocation("scheme://host/path/../../other", "scheme", Optional.empty(), "host", "path/../../other");
        TestLocation.assertLocation("scheme://host/path/%41%illegal", Optional.of("scheme"), Optional.empty(), Optional.of("host"), OptionalInt.empty(), "path/%41%illegal", Set.of("Malformed escape pair at index 22: scheme://host/path/%41%illegal"));
        TestLocation.assertLocation("scheme://host///path", "scheme", Optional.empty(), "host", "//path");
        TestLocation.assertLocation("scheme://host///path//", "scheme", Optional.empty(), "host", "//path//");
        TestLocation.assertLocationWithoutUriTesting("scheme://userInfo@host/some/path#fragment", "scheme", Optional.of("userInfo"), "host", "some/path#fragment");
        TestLocation.assertLocationWithoutUriTesting("scheme://userInfo@ho#st/some/path", "scheme", Optional.of("userInfo"), "ho#st", "some/path");
        TestLocation.assertLocationWithoutUriTesting("scheme://user#Info@host/some/path", "scheme", Optional.of("user#Info"), "host", "some/path");
        TestLocation.assertLocationWithoutUriTesting("sc#heme://userInfo@host/some/path", "sc#heme", Optional.of("userInfo"), "host", "some/path");
        TestLocation.assertLocationWithoutUriTesting("scheme://userInfo@host/some/path?fragment", "scheme", Optional.of("userInfo"), "host", "some/path?fragment");
        TestLocation.assertLocationWithoutUriTesting("scheme://userInfo@ho?st/some/path", "scheme", Optional.of("userInfo"), "ho?st", "some/path");
        TestLocation.assertLocationWithoutUriTesting("scheme://user?Info@host/some/path", "scheme", Optional.of("user?Info"), "host", "some/path");
        TestLocation.assertLocationWithoutUriTesting("sc?heme://userInfo@host/some/path", "sc?heme", Optional.of("userInfo"), "host", "some/path");
        TestLocation.assertLocation("scheme://", Optional.of("scheme"), Optional.empty(), Optional.empty(), OptionalInt.empty(), "", Set.of("Expected authority at index 9: scheme://"));
        TestLocation.assertLocation("scheme://host/", "scheme", Optional.empty(), "host", "");
        TestLocation.assertLocation("scheme:///", "scheme", Optional.empty(), "", "");
        TestLocation.assertLocation("scheme://host//", "scheme", Optional.empty(), "host", "/");
        TestLocation.assertLocation("scheme:////", "scheme", Optional.empty(), "", "/");
        TestLocation.assertLocation("/", "");
        TestLocation.assertLocation("//", "/", Set.of("Expected authority at index 2: //"));
        TestLocation.assertLocation("///", "//", Set.of("'/path' compared with URI: expected [/], was [///]"));
        TestLocation.assertLocation("/abc", "abc");
        TestLocation.assertLocation("//abc", "/abc", Set.of("host compared with URI: expected [Optional[abc]], was [Optional.empty]", "'/path' compared with URI: expected [], was [//abc]"));
        TestLocation.assertLocation("///abc", "//abc", Set.of("'/path' compared with URI: expected [/abc], was [///abc]"));
        TestLocation.assertLocation("/abc/xyz", "abc/xyz");
        TestLocation.assertLocation("/foo://host:port/path", "foo://host:port/path");
        TestLocation.assertLocation("file:/", "file", "");
        TestLocation.assertLocation("file://", Optional.of("file"), Optional.empty(), Optional.empty(), OptionalInt.empty(), "", Set.of("Expected authority at index 7: file://"));
        TestLocation.assertLocation("file:///", "file", "");
        TestLocation.assertLocation("file:////", "file", "/");
        TestLocation.assertLocation("file://///", "file", "//");
        TestLocation.assertLocation("file:/hello.txt", "file", "hello.txt");
        TestLocation.assertLocation("file:/some/path", "file", "some/path");
        TestLocation.assertLocation("file:/some@what/path", "file", "some@what/path");
        TestLocation.assertLocation("hdfs:/a/hadoop/path.csv", "hdfs", "a/hadoop/path.csv");
        TestLocation.assertLocation("file:///tmp/staging/dir/some-user@example.com", "file", "tmp/staging/dir/some-user@example.com");
        Assertions.assertThatThrownBy(() -> Location.of(null)).isInstanceOf(NullPointerException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("location is empty");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"  ")).isInstanceOf(IllegalArgumentException.class)).hasMessage("location is blank");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("No scheme for file system location: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"dev/null")).isInstanceOf(IllegalArgumentException.class)).hasMessage("No scheme for file system location: dev/null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://host:invalid/path")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid port in file system location: scheme://host:invalid/path");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://:")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid port in file system location: scheme://:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://:/")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid port in file system location: scheme://:/");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://@:/")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid port in file system location: scheme://@:/");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://host")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://host");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://userInfo@host")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://userInfo@host");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://userInfo@host:1234")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://userInfo@host:1234");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://@")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://@");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://@:1")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://@:1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://:1")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Path missing in file system location: scheme://:1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)"scheme://:")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid port in file system location: scheme://:");
    }

    private static void assertLocationWithoutUriTesting(String locationString, String scheme, Optional<String> userInfo, String host, String path) {
        Optional<String> expectedHost = host.isEmpty() ? Optional.empty() : Optional.of(host);
        TestLocation.assertLocation(Location.of((String)locationString), locationString, Optional.of(scheme), userInfo, expectedHost, OptionalInt.empty(), path, true, Set.of("skipped"));
    }

    private static void assertLocation(String locationString, String scheme, Optional<String> userInfo, String host, String path) {
        Optional<String> expectedHost = host.isEmpty() ? Optional.empty() : Optional.of(host);
        TestLocation.assertLocation(locationString, Optional.of(scheme), userInfo, expectedHost, OptionalInt.empty(), path, Set.of());
    }

    private static void assertLocation(String locationString, String scheme, String path) {
        TestLocation.assertLocation(locationString, Optional.of(scheme), Optional.empty(), Optional.empty(), OptionalInt.empty(), path, Set.of());
    }

    private static void assertLocation(String locationString, String scheme, String host, int port, String path) {
        TestLocation.assertLocation(locationString, Optional.of(scheme), Optional.empty(), Optional.of(host), OptionalInt.of(port), path, Set.of());
    }

    private static void assertLocation(String locationString, String path) {
        TestLocation.assertLocation(locationString, path, Set.of());
    }

    private static void assertLocation(String locationString, String path, Set<String> uriIncompatibilities) {
        TestLocation.assertLocation(locationString, Optional.empty(), Optional.empty(), Optional.empty(), OptionalInt.empty(), path, uriIncompatibilities);
    }

    private static void assertLocation(Location actual, Location expected) {
        TestLocation.assertLocation(actual, expected.toString(), expected.scheme(), expected.userInfo(), expected.host(), expected.port(), expected.path(), true, Set.of("skipped"));
    }

    private static void assertLocation(String locationString, Optional<String> scheme, Optional<String> userInfo, Optional<String> host, OptionalInt port, String path) {
        TestLocation.assertLocation(locationString, scheme, userInfo, host, port, path, Set.of());
    }

    private static void assertLocation(String locationString, Optional<String> scheme, Optional<String> userInfo, Optional<String> host, OptionalInt port, String path, Set<String> uriIncompatibilities) {
        Location location = Location.of((String)locationString);
        TestLocation.assertLocation(location, locationString, scheme, userInfo, host, port, path, false, uriIncompatibilities);
    }

    private static void assertLocation(Location location, String locationString, Optional<String> scheme, Optional<String> userInfo, Optional<String> host, OptionalInt port, String path, boolean skipUriTesting, Set<String> uriIncompatibilities) {
        Assertions.assertThat((String)location.toString()).isEqualTo(locationString);
        Assertions.assertThat((Optional)location.scheme()).isEqualTo(scheme);
        Assertions.assertThat((Optional)location.userInfo()).isEqualTo(userInfo);
        Assertions.assertThat((Optional)location.host()).isEqualTo(host);
        Assertions.assertThat((OptionalInt)location.port()).isEqualTo((Object)port);
        Assertions.assertThat((String)location.path()).isEqualTo(path);
        if (!skipUriTesting) {
            int observedIncompatibilities = 0;
            URI uri = null;
            try {
                uri = new URI(locationString);
            }
            catch (URISyntaxException e) {
                Assertions.assertThat(uriIncompatibilities).contains((Object[])new String[]{e.getMessage()});
                ++observedIncompatibilities;
            }
            if (uri != null) {
                observedIncompatibilities += TestLocation.assertEqualsOrVerifyDeviation(Optional.ofNullable(uri.getScheme()), location.scheme(), "scheme compared with URI", uriIncompatibilities);
                observedIncompatibilities += TestLocation.assertEqualsOrVerifyDeviation(Optional.ofNullable(uri.getUserInfo()), location.userInfo(), "userInfo compared with URI", uriIncompatibilities);
                observedIncompatibilities += TestLocation.assertEqualsOrVerifyDeviation(Optional.ofNullable(uri.getHost()), location.host(), "host compared with URI", uriIncompatibilities);
                observedIncompatibilities += TestLocation.assertEqualsOrVerifyDeviation(uri.getPort() == -1 ? OptionalInt.empty() : OptionalInt.of(uri.getPort()), location.port(), "port compared with URI", uriIncompatibilities);
                observedIncompatibilities += TestLocation.assertEqualsOrVerifyDeviation(uri.getPath(), "/" + location.path(), "'/path' compared with URI", uriIncompatibilities);
            }
            Assertions.assertThat(uriIncompatibilities).hasSize(observedIncompatibilities);
        } else {
            Assertions.assertThat(uriIncompatibilities).isEqualTo(Set.of("skipped"));
        }
        Assertions.assertThat((String)location.toString()).isEqualTo(locationString);
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)location, new Object[]{Location.of((String)locationString)}).check();
    }

    private static <T> int assertEqualsOrVerifyDeviation(T expected, T actual, String message, Set<String> expectedDifferences) {
        if (Objects.equals(expected, actual)) {
            return 0;
        }
        String key = "%s: expected [%s], was [%s]".formatted(message, expected, actual);
        Assertions.assertThat(expectedDifferences).contains((Object[])new String[]{key});
        return 1;
    }

    @Test
    void testVerifyFileLocation() {
        Location.of((String)"scheme://userInfo@host/name").verifyValidFileLocation();
        Location.of((String)"scheme://userInfo@host/path/name").verifyValidFileLocation();
        Location.of((String)"scheme://userInfo@host/name ").verifyValidFileLocation();
        Location.of((String)"/name").verifyValidFileLocation();
        Location.of((String)"/path/name").verifyValidFileLocation();
        Location.of((String)"/path/name ").verifyValidFileLocation();
        Location.of((String)"/name ").verifyValidFileLocation();
        TestLocation.assertInvalidFileLocation("scheme://userInfo@host/", "File location must contain a path: scheme://userInfo@host/");
        TestLocation.assertInvalidFileLocation("scheme://userInfo@host/name/", "File location cannot end with '/': scheme://userInfo@host/name/");
        TestLocation.assertInvalidFileLocation("/", "File location must contain a path: /");
        TestLocation.assertInvalidFileLocation("/name/", "File location cannot end with '/': /name/");
    }

    private static void assertInvalidFileLocation(String locationString, String expectedErrorMessage) {
        Location location = Location.of((String)locationString);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Location)location).verifyValidFileLocation()).isInstanceOf(IllegalStateException.class)).hasMessageContaining(locationString).hasMessage(expectedErrorMessage);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Location)location).fileName()).isInstanceOf(IllegalStateException.class)).hasMessageContaining(locationString).hasMessage(expectedErrorMessage);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Location)location).parentDirectory()).isInstanceOf(IllegalStateException.class)).hasMessageContaining(locationString).hasMessage(expectedErrorMessage);
    }

    @Test
    void testFileName() {
        TestLocation.assertFileName("scheme://userInfo@host/path/name", "name");
        TestLocation.assertFileName("scheme://userInfo@host/name", "name");
        TestLocation.assertFileName("/path/name", "name");
        TestLocation.assertFileName("/name", "name");
    }

    private static void assertFileName(String locationString, String fileName) {
        Location location = Location.of((String)locationString);
        location.verifyValidFileLocation();
        Assertions.assertThat((String)location.fileName()).isEqualTo(fileName);
    }

    @Test
    void testSibling() {
        TestLocation.assertSiblingFailure("/", "sibling", IllegalStateException.class, "File location must contain a path: /");
        TestLocation.assertSiblingFailure("//", "sibling", IllegalStateException.class, "File location must contain a path: /");
        TestLocation.assertSiblingFailure("file:/", "sibling", IllegalStateException.class, "File location must contain a path: file:/");
        TestLocation.assertSiblingFailure("file://", "sibling", IllegalStateException.class, "File location must contain a path: file://");
        TestLocation.assertSiblingFailure("file:///", "sibling", IllegalStateException.class, "File location must contain a path: file:///");
        TestLocation.assertSiblingFailure("s3://bucket/", "sibling", IllegalStateException.class, "File location must contain a path: s3://bucket/");
        TestLocation.assertSiblingFailure("scheme://userInfo@host/path/", "sibling", IllegalStateException.class, "File location cannot end with '/'");
        TestLocation.assertSiblingFailure("scheme://userInfo@host/path/filename", null, NullPointerException.class, "name is null");
        TestLocation.assertSiblingFailure("scheme://userInfo@host/path/filename", "", IllegalArgumentException.class, "name is empty");
        TestLocation.assertSibling("scheme://userInfo@host/path/name", "sibling", "scheme://userInfo@host/path/sibling");
        TestLocation.assertSibling("scheme://userInfo@host/path//name", "sibling", "scheme://userInfo@host/path//sibling");
        TestLocation.assertSibling("scheme://userInfo@host/path///name", "sibling", "scheme://userInfo@host/path///sibling");
        TestLocation.assertSibling("scheme://userInfo@host/level1/level2/name", "sibling", "scheme://userInfo@host/level1/level2/sibling");
        TestLocation.assertSibling("scheme://userInfo@host/level1//level2/name", "sibling", "scheme://userInfo@host/level1//level2/sibling");
        TestLocation.assertSibling("file:/path/name", "sibling", "file:/path/sibling");
        TestLocation.assertSibling("s3://bucket/directory/filename with spaces", "sibling", "s3://bucket/directory/sibling");
        TestLocation.assertSibling("/path/name", "sibling", "/path/sibling");
        TestLocation.assertSibling("/name", "sibling", "/sibling");
    }

    private static void assertSiblingFailure(String locationString, String siblingName, Class<?> exceptionClass, String exceptionMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Location.of((String)locationString).sibling(siblingName)).isInstanceOf(exceptionClass)).hasMessageContaining(exceptionMessage);
    }

    private static void assertSibling(String locationString, String siblingName, String expectedLocationString) {
        Location location = Location.of((String)locationString);
        location.verifyValidFileLocation();
        Location siblingLocation = location.sibling(siblingName);
        TestLocation.assertLocation(siblingLocation, Location.of((String)expectedLocationString));
    }

    @Test
    void testParentDirectory() {
        TestLocation.assertParentDirectoryFailure("scheme:/", "File location must contain a path: scheme:/");
        TestLocation.assertParentDirectoryFailure("scheme://", "File location must contain a path: scheme://");
        TestLocation.assertParentDirectoryFailure("scheme:///", "File location must contain a path: scheme:///");
        TestLocation.assertParentDirectoryFailure("scheme://host/", "File location must contain a path: scheme://host/");
        TestLocation.assertParentDirectoryFailure("scheme://userInfo@host/", "File location must contain a path: scheme://userInfo@host/");
        TestLocation.assertParentDirectoryFailure("scheme://userInfo@host:1234/", "File location must contain a path: scheme://userInfo@host:1234/");
        TestLocation.assertParentDirectoryFailure("scheme://host//", "File location must contain a path: scheme://host//");
        TestLocation.assertParentDirectoryFailure("scheme://userInfo@host//", "File location must contain a path: scheme://userInfo@host//");
        TestLocation.assertParentDirectoryFailure("scheme://userInfo@host:1234//", "File location must contain a path: scheme://userInfo@host:1234//");
        TestLocation.assertParentDirectory("scheme://userInfo@host/path/name", Location.of((String)"scheme://userInfo@host/path"));
        TestLocation.assertParentDirectory("scheme://userInfo@host:1234/name", Location.of((String)"scheme://userInfo@host:1234/"));
        TestLocation.assertParentDirectory("scheme://userInfo@host/path//name", Location.of((String)"scheme://userInfo@host/path/"));
        TestLocation.assertParentDirectory("scheme://userInfo@host/path///name", Location.of((String)"scheme://userInfo@host/path//"));
        TestLocation.assertParentDirectory("scheme://userInfo@host/path:/name", Location.of((String)"scheme://userInfo@host/path:"));
        TestLocation.assertParentDirectoryFailure("/", "File location must contain a path: /");
        TestLocation.assertParentDirectoryFailure("//", "File location must contain a path: //");
        TestLocation.assertParentDirectory("/path/name", Location.of((String)"/path"));
        TestLocation.assertParentDirectory("/name", Location.of((String)"/"));
        TestLocation.assertParentDirectoryFailure("/path/name/", "File location cannot end with '/': /path/name/");
        TestLocation.assertParentDirectoryFailure("/name/", "File location cannot end with '/': /name/");
        TestLocation.assertParentDirectory("/path//name", Location.of((String)"/path/"));
        TestLocation.assertParentDirectory("/path///name", Location.of((String)"/path//"));
        TestLocation.assertParentDirectory("/path:/name", Location.of((String)"/path:"));
    }

    private static void assertParentDirectory(String locationString, Location parentLocation) {
        Location location = Location.of((String)locationString);
        location.verifyValidFileLocation();
        Location parentDirectory = location.parentDirectory();
        TestLocation.assertLocation(parentDirectory, parentLocation);
    }

    private static void assertParentDirectoryFailure(String locationString, @Language(value="RegExp") String expectedMessagePattern) {
        Assertions.assertThatThrownBy(() -> ((Location)Location.of((String)locationString)).parentDirectory()).hasMessageMatching(expectedMessagePattern);
    }

    @Test
    void testAppendPath() {
        TestLocation.assertAppendPath("scheme://userInfo@host/", "name", Location.of((String)"scheme://userInfo@host/name"));
        TestLocation.assertAppendPath("scheme://userInfo@host:1234/path", "name", Location.of((String)"scheme://userInfo@host:1234/path/name"));
        TestLocation.assertAppendPath("scheme://userInfo@host/path/", "name", Location.of((String)"scheme://userInfo@host/path/name"));
        TestLocation.assertAppendPath("scheme://userInfo@host/path//", "name", Location.of((String)"scheme://userInfo@host/path//name"));
        TestLocation.assertAppendPath("scheme://userInfo@host/path:", "name", Location.of((String)"scheme://userInfo@host/path:/name"));
        TestLocation.assertAppendPath("scheme://", "name", Location.of((String)"scheme:///name"));
        TestLocation.assertAppendPath("scheme:///", "name", Location.of((String)"scheme:///name"));
        TestLocation.assertAppendPath("scheme:///path", "name", Location.of((String)"scheme:///path/name"));
        TestLocation.assertAppendPath("scheme:///path/", "name", Location.of((String)"scheme:///path/name"));
        TestLocation.assertAppendPath("/", "name", Location.of((String)"/name"));
        TestLocation.assertAppendPath("/path", "name", Location.of((String)"/path/name"));
        TestLocation.assertAppendPath("/tmp", "username@example.com", Location.of((String)"/tmp/username@example.com"));
        TestLocation.assertAppendPath("file:///tmp", "username@example.com", Location.of((String)"file:///tmp/username@example.com"));
    }

    private static void assertAppendPath(String locationString, String newPathElement, Location expected) {
        Location location = Location.of((String)locationString).appendPath(newPathElement);
        TestLocation.assertLocation(location, expected);
    }

    @Test
    void testAppendSuffix() {
        TestLocation.assertAppendSuffix("scheme://userInfo@host/", ".ext", Location.of((String)"scheme://userInfo@host/.ext"));
        TestLocation.assertAppendSuffix("scheme://userInfo@host:1234/path", ".ext", Location.of((String)"scheme://userInfo@host:1234/path.ext"));
        TestLocation.assertAppendSuffix("scheme://userInfo@host/path/", ".ext", Location.of((String)"scheme://userInfo@host/path/.ext"));
        TestLocation.assertAppendSuffix("scheme://userInfo@host/path//", ".ext", Location.of((String)"scheme://userInfo@host/path//.ext"));
        TestLocation.assertAppendSuffix("scheme://userInfo@host/path:", ".ext", Location.of((String)"scheme://userInfo@host/path:.ext"));
        TestLocation.assertAppendSuffix("scheme://", ".ext", Location.of((String)"scheme:///.ext"));
        TestLocation.assertAppendSuffix("scheme:///", ".ext", Location.of((String)"scheme:///.ext"));
        TestLocation.assertAppendSuffix("scheme:///path", ".ext", Location.of((String)"scheme:///path.ext"));
        TestLocation.assertAppendSuffix("scheme:///path/", ".ext", Location.of((String)"scheme:///path/.ext"));
        TestLocation.assertAppendSuffix("scheme:///path", "/foo", Location.of((String)"scheme:///path/foo"));
        TestLocation.assertAppendSuffix("scheme:///path/", "/foo", Location.of((String)"scheme:///path//foo"));
        TestLocation.assertAppendSuffix("/", ".ext", Location.of((String)"/.ext"));
        TestLocation.assertAppendSuffix("/path", ".ext", Location.of((String)"/path.ext"));
    }

    private static void assertAppendSuffix(String locationString, String suffix, Location expected) {
        Location location = Location.of((String)locationString).appendSuffix(suffix);
        TestLocation.assertLocation(location, expected);
    }
}

