/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestLocations {
    private static Stream<Arguments> locations() {
        return Stream.of(Arguments.of((Object[])new Object[]{"test_dir", "", "test_dir/"}), Arguments.of((Object[])new Object[]{"", "test_file.txt", "/test_file.txt"}), Arguments.of((Object[])new Object[]{"test_dir", "test_file.txt", "test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"/test_dir", "test_file.txt", "/test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"test_dir/", "test_file.txt", "test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"/test_dir/", "test_file.txt", "/test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"test_dir", "test_dir2/", "test_dir/test_dir2/"}), Arguments.of((Object[])new Object[]{"test_dir/", "test_dir2/", "test_dir/test_dir2/"}), Arguments.of((Object[])new Object[]{"s3:/test_dir", "test_file.txt", "s3:/test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"s3://test_dir", "test_file.txt", "s3://test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"s3://test_dir/", "test_file.txt", "s3://test_dir/test_file.txt"}), Arguments.of((Object[])new Object[]{"s3://test_dir/", "location?", "s3://test_dir/location?"}), Arguments.of((Object[])new Object[]{"s3://test_dir/", "location#", "s3://test_dir/location#"}), Arguments.of((Object[])new Object[]{"s3://dir_with_space ", "test_file.txt", "s3://dir_with_space /test_file.txt"}), Arguments.of((Object[])new Object[]{"s3://dir_with_double_space  ", "test_file.txt", "s3://dir_with_double_space  /test_file.txt"}));
    }

    @ParameterizedTest
    @MethodSource(value={"locations"})
    public void testAppendPath(String location, String path, String expected) {
        Assertions.assertThat((String)Locations.appendPath((String)location, (String)path)).isEqualTo(expected);
    }

    @Test
    public void testDirectoryLocationEquivalence() {
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/", "scheme://authority/", true);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/", "scheme://authority//", false);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/", "scheme://authority///", false);
        TestLocations.assertDirectoryLocationEquivalence("scheme://userInfo@host:1234/dir", "scheme://userInfo@host:1234/dir/", true);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path", "scheme://authority/some/path", true);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path", "scheme://authority/some/path/", true);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path", "scheme://authority/some/path//", false);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path//", "scheme://authority/some/path//", true);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path/", "scheme://authority/some/path//", false);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some/path//", "scheme://authority/some/path///", false);
        TestLocations.assertDirectoryLocationEquivalence("scheme://authority/some//path", "scheme://authority/some//path/", true);
    }

    private static void assertDirectoryLocationEquivalence(String leftLocation, String rightLocation, boolean equivalent) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Locations.areDirectoryLocationsEquivalent((Location)Location.of((String)leftLocation), (Location)Location.of((String)rightLocation))).as("equivalence of '%s' in relation to '%s'", new Object[]{leftLocation, rightLocation})).isEqualTo(equivalent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Locations.areDirectoryLocationsEquivalent((Location)Location.of((String)rightLocation), (Location)Location.of((String)leftLocation))).as("equivalence of '%s' in relation to '%s'", new Object[]{rightLocation, leftLocation})).isEqualTo(equivalent);
    }

    @Test
    void testIsS3Tables() {
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://e97725d9-dbfb-4334-784sox7edps35ncq16arh546frqa1use2b--table-s3")).isTrue();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://75fed916-b871-4909-mx9t6iohbseks57q16e5y6nf1c8gguse2b--table-s3")).isTrue();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://e97725d9-dbfb-4334-784sox7edps35ncq16arh546frqa1use2b--table-s3/")).isFalse();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://75fed916-b871-4909-mx9t6iohbseks57q16e5y6nf1c8gguse2b--table-s3/")).isFalse();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://75fed916-b871-4909/mx9t6iohbseks57q16e5y6nf1c8gguse2b--table-s3")).isFalse();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://test-bucket")).isFalse();
        Assertions.assertThat((boolean)Locations.isS3Tables((String)"s3://test-bucket/default")).isFalse();
    }
}

