/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.AbstractTestTrinoFileSystem;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.local.LocalFileSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestLocalFileSystem
extends AbstractTestTrinoFileSystem {
    private LocalFileSystem fileSystem;
    private Path tempDirectory;

    @BeforeAll
    void beforeAll() throws IOException {
        this.tempDirectory = Files.createTempDirectory("test", new FileAttribute[0]);
        this.fileSystem = new LocalFileSystem(this.tempDirectory);
    }

    @Override
    protected boolean supportsCreateExclusive() {
        return false;
    }

    @AfterEach
    void afterEach() throws IOException {
        this.cleanupFiles();
    }

    @AfterAll
    void afterAll() throws IOException {
        Files.delete(this.tempDirectory);
    }

    private void cleanupFiles() throws IOException {
        try (Stream<Path> walk = Files.walk(this.tempDirectory, new FileVisitOption[0]);){
            Iterator iterator = walk.sorted(Comparator.reverseOrder()).iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                if (path.equals(this.tempDirectory)) continue;
                Files.delete(path);
            }
        }
    }

    @Override
    protected boolean isHierarchical() {
        return true;
    }

    @Override
    protected boolean supportsIncompleteWriteNoClobber() {
        return false;
    }

    @Override
    protected TrinoFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    protected Location getRootLocation() {
        return Location.of((String)"local://");
    }

    @Override
    protected void verifyFileSystemIsEmpty() {
        try (Stream<Path> entries = Files.list(this.tempDirectory);){
            Assertions.assertThat(entries.filter(Predicate.not(this.tempDirectory::equals)).findFirst()).isEmpty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    void testPathsOutOfBounds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().newInputFile(this.createLocation("../file"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().newInputFile(this.createLocation("../file"), 22L)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().newOutputFile(this.createLocation("../file"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().deleteFile(this.createLocation("../file"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().listFiles(this.createLocation("../file"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().renameFile(this.createLocation("../file"), this.createLocation("target"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().renameFile(this.createLocation("source"), this.createLocation("../file"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(this.createLocation("../file").toString());
    }
}

