/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.filesystem.local.LocalFileSystemConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class TestLocalFileSystemConfig {
    TestLocalFileSystemConfig() {
    }

    @Test
    void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((LocalFileSystemConfig)ConfigAssertions.recordDefaults(LocalFileSystemConfig.class)).setLocation(Paths.get(System.getProperty(StandardSystemProperty.JAVA_IO_TMPDIR.key()), new String[0])));
    }

    @Test
    void testExplicitPropertyMappings(@TempDir Path tempDirectory) {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"local.location", (Object)tempDirectory.toString()).buildOrThrow();
        LocalFileSystemConfig expected = new LocalFileSystemConfig().setLocation(tempDirectory);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

