/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.AbstractTestTrinoFileSystem;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.cache.CacheFileSystem;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.DefaultCacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystem;
import io.trino.filesystem.memory.MemoryFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystemCacheConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestMemoryFileSystemCache
extends AbstractTestTrinoFileSystem {
    private static final int MAX_CONTENT_LENGTH = 0x200000;
    private MemoryFileSystem delegate;
    private CacheFileSystem fileSystem;
    private MemoryFileSystemCache cache;
    private CacheKeyProvider cacheKeyProvider;

    @BeforeAll
    void beforeAll() {
        MemoryFileSystemCacheConfig configuration = new MemoryFileSystemCacheConfig().setMaxContentLength(DataSize.ofBytes((long)0x200000L)).setCacheTtl(new Duration(8.0, TimeUnit.HOURS));
        this.delegate = new MemoryFileSystem();
        this.cache = new MemoryFileSystemCache(configuration);
        this.cacheKeyProvider = new DefaultCacheKeyProvider();
        this.fileSystem = new CacheFileSystem((TrinoFileSystem)this.delegate, (TrinoFileSystemCache)this.cache, this.cacheKeyProvider);
    }

    @Override
    protected boolean isHierarchical() {
        return false;
    }

    @Override
    protected TrinoFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    protected Location getRootLocation() {
        return Location.of((String)"memory://");
    }

    @Override
    protected void verifyFileSystemIsEmpty() {
        Assertions.assertThat((boolean)this.delegate.isEmpty()).isTrue();
    }

    @Test
    public void testMaxContentLength() throws IOException {
        int fileSize = 2097352;
        Location location = this.writeFile(fileSize);
        TrinoInputFile inputFile = this.getFileSystem().newInputFile(location);
        long largeFileSkippedCount = this.cache.getLargeFileSkippedCount();
        try (TrinoInput input = inputFile.newInput();){
            input.readTail(fileSize);
        }
        Assertions.assertThat((long)this.cache.getLargeFileSkippedCount()).isGreaterThan(largeFileSkippedCount);
        Assertions.assertThat((boolean)this.cache.isCached((String)this.cacheKeyProvider.getCacheKey(inputFile).orElseThrow())).isFalse();
        this.getFileSystem().deleteFile(location);
        fileSize = 2096952;
        location = this.writeFile(fileSize);
        inputFile = this.getFileSystem().newInputFile(location);
        input = inputFile.newInput();
        try {
            input.readTail(fileSize);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        Assertions.assertThat((boolean)this.cache.isCached((String)this.cacheKeyProvider.getCacheKey(inputFile).orElseThrow())).isTrue();
        this.getFileSystem().deleteFile(location);
    }

    private Location writeFile(int fileSize) throws IOException {
        Location location = this.getRootLocation().appendPath("testMaxContentLength-%s".formatted(UUID.randomUUID()));
        this.getFileSystem().deleteFile(location);
        try (OutputStream outputStream = this.getFileSystem().newOutputFile(location).create();){
            byte[] bytes = new byte[8192];
            Arrays.fill(bytes, (byte)97);
            for (int count = 0; count < fileSize; count += bytes.length) {
                outputStream.write(bytes, 0, Math.min(bytes.length, fileSize - count));
            }
        }
        return location;
    }
}

