/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import com.google.common.collect.ImmutableList;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.tracing.CacheSystemAttributes;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class CacheFileSystemTraceUtils {
    private CacheFileSystemTraceUtils() {
    }

    public static List<SpanData> getCacheOperationSpans(QueryRunner queryRunner) {
        return (List)queryRunner.getSpans().stream().filter(span -> span.getName().startsWith("Input.") || span.getName().startsWith("InputFile.") || span.getName().startsWith("Alluxio.")).filter(span -> !span.getName().startsWith("InputFile.newInput")).filter(span -> !CacheFileSystemTraceUtils.isTrinoSchemaOrPermissions(CacheFileSystemTraceUtils.getFileLocation(span))).collect(ImmutableList.toImmutableList());
    }

    public static String getFileLocation(SpanData span) {
        if (span.getName().startsWith("Input.") || span.getName().startsWith("InputFile.")) {
            return Objects.requireNonNull((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION));
        }
        return Objects.requireNonNull((String)span.getAttributes().get(CacheSystemAttributes.CACHE_FILE_LOCATION));
    }

    public static boolean isTrinoSchemaOrPermissions(String path) {
        return path.endsWith(".trinoSchema") || path.contains(".trinoPermissions") || path.contains(".roleGrants") || path.contains(".roles");
    }

    public record CacheOperation(String operationName, String fileId, OptionalLong position, OptionalLong length) {
        public CacheOperation(String operationName, String fileId, long position, long length) {
            this(operationName, fileId, OptionalLong.of(position), OptionalLong.of(length));
        }

        public CacheOperation(String operationName, String fileId) {
            this(operationName, fileId, OptionalLong.empty(), OptionalLong.empty());
        }
    }
}

