/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import java.util.Objects;
import org.eclipse.jetty.util.thread.MonitoredQueuedThreadPool;
import org.weakref.jmx.Managed;

public class MonitoredQueuedThreadPoolMBean {
    private final MonitoredQueuedThreadPool threadPool;

    public MonitoredQueuedThreadPoolMBean(MonitoredQueuedThreadPool threadPool) {
        this.threadPool = Objects.requireNonNull(threadPool, "threadPool is null");
    }

    @Managed(description="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return this.threadPool.getIdleTimeout();
    }

    @Managed(description="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this.threadPool.getMaxThreads();
    }

    @Managed(description="minimum number of threads in the pool")
    public int getMinThreads() {
        return this.threadPool.getMinThreads();
    }

    @Managed(description="name of the thread pool")
    public String getName() {
        return this.threadPool.getName();
    }

    @Managed(description="priority of the threads in the pool")
    public int getPriority() {
        return this.threadPool.getThreadsPriority();
    }

    @Managed(description="size of the job queue")
    public int getQueueSize() {
        return this.threadPool.getQueueSize();
    }

    @Managed(description="threshold at which the pool is low on threads")
    public int getLowThreadsThreshold() {
        return this.threadPool.getLowThreadsThreshold();
    }

    @Managed(description="number of threads in the pool")
    public int getThreads() {
        return this.threadPool.getThreads();
    }

    @Managed(description="number of idle threads in the pool")
    public int getIdleThreads() {
        return this.threadPool.getIdleThreads();
    }

    @Managed(description="number of busy threads in the pool")
    public int getBusyThreads() {
        return this.threadPool.getBusyThreads();
    }

    @Managed(description="whether thread pool is low on threads")
    public boolean isLowOnThreads() {
        return this.threadPool.isLowOnThreads();
    }

    @Managed(description="the number of tasks executed")
    public long getTasks() {
        return this.threadPool.getTasks();
    }

    @Managed(description="the maximum number of busy threads")
    public int getMaxBusyThreads() {
        return this.threadPool.getMaxBusyThreads();
    }

    @Managed(description="the maximum task queue size")
    public int getMaxQueueSize() {
        return this.threadPool.getMaxQueueSize();
    }

    @Managed(description="the average time a task remains in the queue, in nanoseconds")
    public long getAverageQueueLatency() {
        return this.threadPool.getAverageQueueLatency();
    }

    @Managed(description="the maximum time a task remains in the queue, in nanoseconds")
    public long getMaxQueueLatency() {
        return this.threadPool.getMaxQueueLatency();
    }

    @Managed(description="the average task execution time, in nanoseconds")
    public long getAverageTaskLatency() {
        return this.threadPool.getAverageTaskLatency();
    }

    @Managed(description="the maximum task execution time, in nanoseconds")
    public long getMaxTaskLatency() {
        return this.threadPool.getMaxTaskLatency();
    }
}

