/*
 * Decompiled with CFR 0.152.
 */
package io.trino.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public enum GeometryType {
    POINT(false, Slices.utf8Slice((String)"ST_Point")),
    MULTI_POINT(true, Slices.utf8Slice((String)"ST_MultiPoint")),
    LINE_STRING(false, Slices.utf8Slice((String)"ST_LineString")),
    MULTI_LINE_STRING(true, Slices.utf8Slice((String)"ST_MultiLineString")),
    POLYGON(false, Slices.utf8Slice((String)"ST_Polygon")),
    MULTI_POLYGON(true, Slices.utf8Slice((String)"ST_MultiPolygon")),
    GEOMETRY_COLLECTION(true, Slices.utf8Slice((String)"ST_GeomCollection"));

    private final boolean multitype;
    private final Slice standardName;

    private GeometryType(boolean multitype, Slice standardName) {
        this.multitype = multitype;
        this.standardName = standardName;
    }

    public boolean isMultitype() {
        return this.multitype;
    }

    public Slice standardName() {
        return this.standardName;
    }

    public static GeometryType getForEsriGeometryType(String type) {
        return GeometryType.getForInternalLibraryName(type);
    }

    public static GeometryType getForJtsGeometryType(String type) {
        return GeometryType.getForInternalLibraryName(type);
    }

    private static GeometryType getForInternalLibraryName(String type) {
        Objects.requireNonNull(type, "type is null");
        return switch (type) {
            case "Point" -> POINT;
            case "MultiPoint" -> MULTI_POINT;
            case "LineString" -> LINE_STRING;
            case "MultiLineString" -> MULTI_LINE_STRING;
            case "Polygon" -> POLYGON;
            case "MultiPolygon" -> MULTI_POLYGON;
            case "GeometryCollection" -> GEOMETRY_COLLECTION;
            default -> throw new IllegalArgumentException("Invalid Geometry Type: " + type);
        };
    }
}

