/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class GeometryType
extends AbstractVariableWidthType {
    public static final GeometryType GEOMETRY = new GeometryType();
    public static final String GEOMETRY_TYPE_NAME = "Geometry";

    private GeometryType() {
        super(new TypeSignature(GEOMETRY_TYPE_NAME, new TypeSignatureParameter[0]), Slice.class);
    }

    protected GeometryType(TypeSignature signature) {
        super(signature, Slice.class);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getSliceLength(position));
        return GeometrySerde.deserialize((Slice)slice).asText();
    }
}

