/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.GroupedAccumulatorState;

public class GeometryStateFactory
implements AccumulatorStateFactory<GeometryState> {
    private static final long OGC_GEOMETRY_BASE_INSTANCE_SIZE = SizeOf.instanceSize(OGCGeometry.class);

    public GeometryState createSingleState() {
        return new SingleGeometryState();
    }

    public GeometryState createGroupedState() {
        return new GroupedGeometryState();
    }

    private static long getGeometryMemorySize(OGCGeometry geometry) {
        if (geometry == null) {
            return 0L;
        }
        if (geometry.isEmpty()) {
            return OGC_GEOMETRY_BASE_INSTANCE_SIZE;
        }
        return geometry.estimateMemorySize();
    }

    public static class SingleGeometryState
    implements GeometryState {
        private OGCGeometry geometry;

        @Override
        public OGCGeometry getGeometry() {
            return this.geometry;
        }

        @Override
        public void setGeometry(OGCGeometry geometry) {
            this.geometry = geometry;
        }

        public long getEstimatedSize() {
            return GeometryStateFactory.getGeometryMemorySize(this.geometry);
        }
    }

    public static class GroupedGeometryState
    implements GeometryState,
    GroupedAccumulatorState {
        private final ObjectBigArray<OGCGeometry> geometries = new ObjectBigArray();
        private int groupId;
        private long size;

        @Override
        public OGCGeometry getGeometry() {
            return (OGCGeometry)this.geometries.get((long)this.groupId);
        }

        @Override
        public void setGeometry(OGCGeometry geometry) {
            OGCGeometry previousValue = (OGCGeometry)this.geometries.getAndSet((long)this.groupId, (Object)geometry);
            this.size -= GeometryStateFactory.getGeometryMemorySize(previousValue);
            this.size += GeometryStateFactory.getGeometryMemorySize(geometry);
        }

        public void ensureCapacity(int size) {
            this.geometries.ensureCapacity((long)size);
        }

        public long getEstimatedSize() {
            return this.size + this.geometries.sizeOf();
        }

        public final void setGroupId(int groupId) {
            this.groupId = groupId;
        }
    }
}

