/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class GeometryType
extends AbstractVariableWidthType {
    public static final GeometryType GEOMETRY = new GeometryType();

    private GeometryType() {
        super(new TypeSignature("Geometry", new TypeSignatureParameter[0]), Slice.class);
    }

    protected GeometryType(TypeSignature signature) {
        super(signature, Slice.class);
    }

    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            return GeometrySerde.deserialize((Slice)this.getSlice(block, position)).asText();
        }
        catch (Exception e) {
            return "<invalid geometry>";
        }
    }
}

