/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class GeometryType
extends AbstractVariableWidthType {
    public static final GeometryType GEOMETRY = new GeometryType();
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.builder(Slice.class).addOperators(DEFAULT_READ_OPERATORS).addOperators(DEFAULT_COMPARABLE_OPERATORS).build();

    private GeometryType() {
        super(new TypeSignature("Geometry", new TypeSignatureParameter[0]), Slice.class);
    }

    protected GeometryType(TypeSignature signature) {
        super(signature, Slice.class);
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public boolean isComparable() {
        return true;
    }

    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            return GeometrySerde.deserialize((Slice)this.getSlice(block, position)).asText();
        }
        catch (Exception e) {
            return "<invalid geometry>";
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(Slice value) {
        return value.hashCode();
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.IDENTICAL)
    private static boolean identical(Slice left, @IsNull boolean leftNull, Slice right, @IsNull boolean rightNull) {
        if (leftNull || rightNull) {
            return leftNull == rightNull;
        }
        return left.equals((Object)right);
    }
}

