/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SheetsRecordCursor
implements RecordCursor {
    private final List<SheetsColumnHandle> columnHandles;
    private final long totalBytes;
    private final List<List<String>> dataValues;
    private List<String> fields;
    private int currentIndex;

    public SheetsRecordCursor(List<SheetsColumnHandle> columnHandles, List<List<String>> dataValues) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        Objects.requireNonNull(dataValues, "dataValues is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.dataValues = ImmutableList.copyOf(dataValues);
        long inputLength = 0L;
        for (List<String> objList : dataValues) {
            for (String obj : objList) {
                inputLength += (long)obj.length();
            }
        }
        this.totalBytes = inputLength;
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).columnType();
    }

    public boolean advanceNextPosition() {
        List<String> currentVals = null;
        while (currentVals == null || currentVals.isEmpty()) {
            if (this.currentIndex == this.dataValues.size()) {
                return false;
            }
            currentVals = this.dataValues.get(this.currentIndex++);
        }
        String[] allFields = new String[this.columnHandles.size()];
        for (int i = 0; i < allFields.length; ++i) {
            int ordinalPos = this.columnHandles.get(i).ordinalPosition();
            if (currentVals.size() <= ordinalPos) continue;
            allFields[i] = currentVals.get(ordinalPos);
        }
        this.fields = Arrays.asList(allFields);
        return true;
    }

    private String getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        return this.fields.get(field);
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, (Type)BooleanType.BOOLEAN);
        return Boolean.parseBoolean(this.getFieldValue(field));
    }

    public long getLong(int field) {
        this.checkFieldType(field, (Type)BigintType.BIGINT);
        return Long.parseLong(this.getFieldValue(field));
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        return Double.parseDouble(this.getFieldValue(field));
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Type)VarcharType.createUnboundedVarcharType());
        return Slices.utf8Slice((String)this.getFieldValue(field));
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return Strings.isNullOrEmpty((String)this.getFieldValue(field));
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals((Object)expected), (String)"Expected field %s to be type %s but is %s", (Object)field, (Object)expected, (Object)actual);
    }

    public void close() {
    }
}

