/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.plugin.google.sheets.SheetsRecordCursor;
import io.trino.plugin.google.sheets.SheetsSplit;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SheetsRecordSet
implements RecordSet {
    private final List<SheetsColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final List<List<String>> values;

    public SheetsRecordSet(SheetsSplit split, List<SheetsColumnHandle> columnHandles) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.values = split.values();
        this.columnTypes = columnHandles.stream().map(SheetsColumnHandle::columnType).collect(Collectors.toList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new SheetsRecordCursor(this.columnHandles, this.values);
    }
}

