/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.inject.Inject;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsConnectorTableHandle;
import io.trino.plugin.google.sheets.SheetsSplit;
import io.trino.plugin.google.sheets.SheetsTable;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class SheetsSplitManager
implements ConnectorSplitManager {
    private final SheetsClient sheetsClient;

    @Inject
    public SheetsSplitManager(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        SheetsConnectorTableHandle tableHandle = (SheetsConnectorTableHandle)connectorTableHandle;
        SheetsTable table = this.sheetsClient.getTable(tableHandle).orElseThrow(() -> SheetsConnectorTableHandle.tableNotFound(tableHandle));
        ArrayList<SheetsSplit> splits = new ArrayList<SheetsSplit>();
        splits.add(new SheetsSplit(table.values()));
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

