/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hdfs.FSDataInputStreamTail;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

class HdfsInput
implements TrinoInput {
    private final FSDataInputStream stream;
    private final TrinoInputFile inputFile;

    public HdfsInput(FSDataInputStream stream, TrinoInputFile inputFile) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.stream.readFully(position, buffer, bufferOffset, bufferLength);
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        Slice tail = FSDataInputStreamTail.readTail(this.inputFile.location(), this.inputFile.length(), this.stream, bufferLength).getTailSlice();
        tail.getBytes(0, buffer, bufferOffset, tail.length());
        return tail.length();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public String toString() {
        return this.inputFile.toString();
    }
}

