/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;

public final class HadoopPaths {
    private HadoopPaths() {
    }

    public static Path hadoopPath(String path) {
        Path hadoopPath = new Path(path);
        if ("s3".equals(hadoopPath.toUri().getScheme()) && !path.equals(hadoopPath.toString())) {
            if (hadoopPath.toUri().getFragment() != null) {
                throw new IllegalArgumentException("Unexpected URI fragment in path: " + path);
            }
            URI uri = URI.create(path);
            return new Path(uri + "#" + URLEncoder.encode(uri.getPath(), StandardCharsets.UTF_8));
        }
        return hadoopPath;
    }
}

