/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HdfsFileIterator
implements FileIterator {
    private final String listingPath;
    private final URI listingUri;
    private final RemoteIterator<LocatedFileStatus> iterator;

    public HdfsFileIterator(String listingPath, FileSystem fs, RemoteIterator<LocatedFileStatus> iterator) {
        this.listingPath = Objects.requireNonNull(listingPath, "listingPath is null");
        this.listingUri = new Path(listingPath).makeQualified(fs.getUri(), fs.getWorkingDirectory()).toUri();
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    public FileEntry next() throws IOException {
        LocatedFileStatus status = (LocatedFileStatus)this.iterator.next();
        Verify.verify((boolean)status.isFile(), (String)"iterator returned a non-file: %s", (Object)status);
        URI pathUri = status.getPath().toUri();
        URI relativeUri = this.listingUri.relativize(pathUri);
        Verify.verify((!relativeUri.equals(pathUri) ? 1 : 0) != 0, (String)"cannot relativize [%s] against [%s]", (Object)pathUri, (Object)this.listingUri);
        Object path = this.listingPath;
        if (!relativeUri.getPath().isEmpty()) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + relativeUri.getPath();
        }
        List blocks = (List)Stream.of(status.getBlockLocations()).map(HdfsFileIterator::toTrinoBlock).collect(ImmutableList.toImmutableList());
        return new FileEntry((String)path, status.getLen(), Instant.ofEpochMilli(status.getModificationTime()), blocks.isEmpty() ? Optional.empty() : Optional.of(blocks));
    }

    private static FileEntry.Block toTrinoBlock(BlockLocation location) {
        try {
            return new FileEntry.Block((List)ImmutableList.copyOf((Object[])location.getHosts()), location.getOffset(), location.getLength());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

