/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.tracing.TracingFileSystemFactory;

public class HdfsFileSystemModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(HdfsFileSystemFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public TrinoFileSystemFactory createFileSystemFactory(Tracer tracer, HdfsFileSystemFactory delegate) {
        return new TracingFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate);
    }
}

