/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.hdfs.authentication.AuthenticationModules;
import io.trino.hdfs.authentication.HdfsAuthenticationConfig;
import java.util.function.Predicate;

public class HdfsAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> HdfsAuthenticationModule.noHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.noHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HdfsAuthenticationModule.noHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.simpleImpersonatingHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HdfsAuthenticationModule.kerberosHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HdfsAuthenticationModule.kerberosHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosImpersonatingHdfsAuthenticationModule());
    }

    private void bindAuthenticationModule(Predicate<HdfsAuthenticationConfig> predicate, Module module) {
        this.install(ConditionalModule.conditionalModule(HdfsAuthenticationConfig.class, predicate, (Module)module));
    }

    private static boolean noHdfsAuth(HdfsAuthenticationConfig config) {
        return config.getHdfsAuthenticationType() == HdfsAuthenticationConfig.HdfsAuthenticationType.NONE;
    }

    private static boolean kerberosHdfsAuth(HdfsAuthenticationConfig config) {
        return config.getHdfsAuthenticationType() == HdfsAuthenticationConfig.HdfsAuthenticationType.KERBEROS;
    }
}

