/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.TrinoInputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

class HdfsTrinoInputStream
extends TrinoInputStream {
    private final FSDataInputStream stream;

    HdfsTrinoInputStream(FSDataInputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
    }

    public long getPosition() throws IOException {
        return this.stream.getPos();
    }

    public void seek(long position) throws IOException {
        this.stream.seek(position);
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

