/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import io.trino.hdfs.ConfigurationInitializer;
import io.trino.hdfs.gcs.GcsAccessTokenProvider;
import io.trino.hdfs.gcs.HiveGcsConfig;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class GoogleGcsConfigurationInitializer
implements ConfigurationInitializer {
    private final boolean useGcsAccessToken;
    private final String jsonKeyFilePath;

    @Inject
    public GoogleGcsConfigurationInitializer(HiveGcsConfig config) {
        this.useGcsAccessToken = config.isUseGcsAccessToken();
        this.jsonKeyFilePath = config.getJsonKeyFilePath();
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        config.set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        if (this.useGcsAccessToken) {
            config.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), false);
            config.setClass("fs.gs" + HadoopCredentialConfiguration.ACCESS_TOKEN_PROVIDER_IMPL_SUFFIX.getKey(), GcsAccessTokenProvider.class, AccessTokenProvider.class);
        } else if (this.jsonKeyFilePath != null) {
            config.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), true);
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), this.jsonKeyFilePath);
        }
    }
}

