/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HdfsFileIterator
implements FileIterator {
    private final Location listingLocation;
    private final Path listingPath;
    private final RemoteIterator<LocatedFileStatus> iterator;

    public HdfsFileIterator(Location listingLocation, Path listingPath, RemoteIterator<LocatedFileStatus> iterator) {
        this.listingLocation = Objects.requireNonNull(listingLocation, "listingPath is null");
        this.listingPath = Objects.requireNonNull(listingPath, "listingPath is null");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    public FileEntry next() throws IOException {
        LocatedFileStatus status = (LocatedFileStatus)this.iterator.next();
        Verify.verify((boolean)status.isFile(), (String)"iterator returned a non-file: %s", (Object)status);
        if (status.getPath().equals((Object)this.listingPath)) {
            throw new IOException("Listing location is a file, not a directory: " + this.listingLocation);
        }
        String root = this.listingPath.toUri().getPath();
        String path = status.getPath().toUri().getPath();
        Verify.verify((boolean)path.startsWith(root), (String)"iterator path [%s] not a child of listing path [%s] for location [%s]", (Object)path, (Object)root, (Object)this.listingLocation);
        int index = root.endsWith("/") ? root.length() : root.length() + 1;
        Location location = this.listingLocation.appendPath(path.substring(index));
        List blocks = (List)Stream.of(status.getBlockLocations()).map(HdfsFileIterator::toTrinoBlock).collect(ImmutableList.toImmutableList());
        return new FileEntry(location, status.getLen(), Instant.ofEpochMilli(status.getModificationTime()), blocks.isEmpty() ? Optional.empty() : Optional.of(blocks));
    }

    private static FileEntry.Block toTrinoBlock(BlockLocation location) {
        try {
            return new FileEntry.Block((List)ImmutableList.copyOf((Object[])location.getHosts()), location.getOffset(), location.getLength());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

