/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.s3;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public final class AwsSdkClientCoreStats {
    private final CounterStat awsRequestCount = new CounterStat();
    private final CounterStat awsRetryCount = new CounterStat();
    private final CounterStat awsThrottleExceptions = new CounterStat();
    private final TimeStat awsRequestTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientExecuteTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientRetryPauseTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final AtomicLong awsHttpClientPoolAvailableCount = new AtomicLong();
    private final AtomicLong awsHttpClientPoolLeasedCount = new AtomicLong();
    private final AtomicLong awsHttpClientPoolPendingCount = new AtomicLong();

    @Managed
    @Nested
    public CounterStat getAwsRequestCount() {
        return this.awsRequestCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsRetryCount() {
        return this.awsRetryCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsThrottleExceptions() {
        return this.awsThrottleExceptions;
    }

    @Managed
    @Nested
    public TimeStat getAwsRequestTime() {
        return this.awsRequestTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientExecuteTime() {
        return this.awsClientExecuteTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientRetryPauseTime() {
        return this.awsClientRetryPauseTime;
    }

    @Managed
    public long getAwsHttpClientPoolAvailableCount() {
        return this.awsHttpClientPoolAvailableCount.get();
    }

    @Managed
    public long getAwsHttpClientPoolLeasedCount() {
        return this.awsHttpClientPoolLeasedCount.get();
    }

    @Managed
    public long getAwsHttpClientPoolPendingCount() {
        return this.awsHttpClientPoolPendingCount.get();
    }

    public AwsSdkClientCoreRequestMetricCollector newRequestMetricCollector() {
        return new AwsSdkClientCoreRequestMetricCollector(this);
    }

    public static class AwsSdkClientCoreRequestMetricCollector
    extends RequestMetricCollector {
        private final AwsSdkClientCoreStats stats;

        protected AwsSdkClientCoreRequestMetricCollector(AwsSdkClientCoreStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        public void collectMetrics(Request<?> request, Response<?> response) {
            Number httpClientPoolPendingCount;
            Number httpClientPoolLeasedCount;
            Number httpClientPoolAvailableCount;
            Number throttleExceptions;
            Number retryCounts;
            TimingInfo timingInfo = request.getAWSRequestMetrics().getTimingInfo();
            Number requestCounts = timingInfo.getCounter(AWSRequestMetrics.Field.RequestCount.name());
            if (requestCounts != null) {
                this.stats.awsRequestCount.update(requestCounts.longValue());
            }
            if ((retryCounts = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientRetryCount.name())) != null) {
                this.stats.awsRetryCount.update(retryCounts.longValue());
            }
            if ((throttleExceptions = timingInfo.getCounter(AWSRequestMetrics.Field.ThrottleException.name())) != null) {
                this.stats.awsThrottleExceptions.update(throttleExceptions.longValue());
            }
            if ((httpClientPoolAvailableCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount.name())) != null) {
                this.stats.awsHttpClientPoolAvailableCount.set(httpClientPoolAvailableCount.longValue());
            }
            if ((httpClientPoolLeasedCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount.name())) != null) {
                this.stats.awsHttpClientPoolLeasedCount.set(httpClientPoolLeasedCount.longValue());
            }
            if ((httpClientPoolPendingCount = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount.name())) != null) {
                this.stats.awsHttpClientPoolPendingCount.set(httpClientPoolPendingCount.longValue());
            }
            AwsSdkClientCoreRequestMetricCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.HttpRequestTime, this.stats.awsRequestTime);
            AwsSdkClientCoreRequestMetricCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.ClientExecuteTime, this.stats.awsClientExecuteTime);
            AwsSdkClientCoreRequestMetricCollector.recordSubTimingDurations(timingInfo, AWSRequestMetrics.Field.RetryPauseTime, this.stats.awsClientRetryPauseTime);
        }

        private static void recordSubTimingDurations(TimingInfo timingInfo, AWSRequestMetrics.Field field, TimeStat timeStat) {
            List subTimings = timingInfo.getAllSubMeasurements(field.name());
            if (subTimings != null) {
                for (TimingInfo subTiming : subTimings) {
                    Long endTimeNanos = subTiming.getEndTimeNanoIfKnown();
                    if (endTimeNanos == null) continue;
                    timeStat.addNanos(endTimeNanos - subTiming.getStartTimeNano());
                }
            }
        }
    }
}

