/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.s3;

import com.amazonaws.AbortedException;
import com.amazonaws.metrics.RequestMetricCollector;
import io.airlift.stats.CounterStat;
import io.trino.hdfs.s3.AwsSdkClientCoreStats;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TrinoS3FileSystemStats {
    private final CounterStat activeConnections = new CounterStat();
    private final CounterStat startedUploads = new CounterStat();
    private final CounterStat failedUploads = new CounterStat();
    private final CounterStat successfulUploads = new CounterStat();
    private final CounterStat metadataCalls = new CounterStat();
    private final CounterStat listStatusCalls = new CounterStat();
    private final CounterStat listLocatedStatusCalls = new CounterStat();
    private final CounterStat listObjectsCalls = new CounterStat();
    private final CounterStat otherReadErrors = new CounterStat();
    private final CounterStat awsAbortedExceptions = new CounterStat();
    private final CounterStat socketExceptions = new CounterStat();
    private final CounterStat socketTimeoutExceptions = new CounterStat();
    private final CounterStat getObjectErrors = new CounterStat();
    private final CounterStat getMetadataErrors = new CounterStat();
    private final CounterStat initiateMultipartUploadErrors = new CounterStat();
    private final CounterStat getObjectRetries = new CounterStat();
    private final CounterStat getMetadataRetries = new CounterStat();
    private final CounterStat readRetries = new CounterStat();
    private final CounterStat initiateMultipartUploadRetries = new CounterStat();
    private final AwsSdkClientCoreStats clientCoreStats = new AwsSdkClientCoreStats();

    @Managed
    @Nested
    public CounterStat getActiveConnections() {
        return this.activeConnections;
    }

    @Managed
    @Nested
    public CounterStat getStartedUploads() {
        return this.startedUploads;
    }

    @Managed
    @Nested
    public CounterStat getFailedUploads() {
        return this.failedUploads;
    }

    @Managed
    @Nested
    public CounterStat getSuccessfulUploads() {
        return this.successfulUploads;
    }

    @Managed
    @Nested
    public CounterStat getMetadataCalls() {
        return this.metadataCalls;
    }

    @Managed
    @Nested
    public CounterStat getListStatusCalls() {
        return this.listStatusCalls;
    }

    @Managed
    @Nested
    public CounterStat getListLocatedStatusCalls() {
        return this.listLocatedStatusCalls;
    }

    @Managed
    @Nested
    public CounterStat getListObjectsCalls() {
        return this.listObjectsCalls;
    }

    @Managed
    @Nested
    public CounterStat getGetObjectErrors() {
        return this.getObjectErrors;
    }

    @Managed
    @Nested
    public CounterStat getGetMetadataErrors() {
        return this.getMetadataErrors;
    }

    @Managed
    @Nested
    public CounterStat getInitiateMultipartUploadErrors() {
        return this.initiateMultipartUploadErrors;
    }

    @Managed
    @Nested
    public CounterStat getOtherReadErrors() {
        return this.otherReadErrors;
    }

    @Managed
    @Nested
    public CounterStat getSocketExceptions() {
        return this.socketExceptions;
    }

    @Managed
    @Nested
    public CounterStat getSocketTimeoutExceptions() {
        return this.socketTimeoutExceptions;
    }

    @Managed
    @Nested
    public CounterStat getAwsAbortedExceptions() {
        return this.awsAbortedExceptions;
    }

    @Managed
    @Flatten
    public AwsSdkClientCoreStats getClientCoreStats() {
        return this.clientCoreStats;
    }

    @Managed
    @Nested
    public CounterStat getGetObjectRetries() {
        return this.getObjectRetries;
    }

    @Managed
    @Nested
    public CounterStat getGetMetadataRetries() {
        return this.getMetadataRetries;
    }

    @Managed
    @Nested
    public CounterStat getReadRetries() {
        return this.readRetries;
    }

    @Managed
    @Nested
    public CounterStat getInitiateMultipartUploadRetries() {
        return this.initiateMultipartUploadRetries;
    }

    public RequestMetricCollector newRequestMetricCollector() {
        return this.clientCoreStats.newRequestMetricCollector();
    }

    public void connectionOpened() {
        this.activeConnections.update(1L);
    }

    public void connectionReleased() {
        this.activeConnections.update(-1L);
    }

    public void uploadStarted() {
        this.startedUploads.update(1L);
    }

    public void uploadFailed() {
        this.failedUploads.update(1L);
    }

    public void uploadSuccessful() {
        this.successfulUploads.update(1L);
    }

    public void newMetadataCall() {
        this.metadataCalls.update(1L);
    }

    public void newListStatusCall() {
        this.listStatusCalls.update(1L);
    }

    public void newListLocatedStatusCall() {
        this.listLocatedStatusCalls.update(1L);
    }

    public void newListObjectsCall() {
        this.listObjectsCalls.update(1L);
    }

    public void newReadError(Throwable t) {
        if (t instanceof SocketException) {
            this.socketExceptions.update(1L);
        } else if (t instanceof SocketTimeoutException) {
            this.socketTimeoutExceptions.update(1L);
        } else if (t instanceof AbortedException) {
            this.awsAbortedExceptions.update(1L);
        } else {
            this.otherReadErrors.update(1L);
        }
    }

    public void newGetObjectError() {
        this.getObjectErrors.update(1L);
    }

    public void newGetMetadataError() {
        this.getMetadataErrors.update(1L);
    }

    public void newInitiateMultipartUploadError() {
        this.initiateMultipartUploadErrors.update(1L);
    }

    public void newGetObjectRetry() {
        this.getObjectRetries.update(1L);
    }

    public void newGetMetadataRetry() {
        this.getMetadataRetries.update(1L);
    }

    public void newReadRetry() {
        this.readRetries.update(1L);
    }

    public void newInitiateMultipartUploadRetry() {
        this.initiateMultipartUploadRetries.update(1L);
    }
}

