/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.azure;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import io.trino.hadoop.;
import io.trino.hdfs.ConfigurationInitializer;
import io.trino.hdfs.azure.HiveAzureConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;

public class TrinoAzureConfigurationInitializer
implements ConfigurationInitializer {
    private final Optional<String> wasbAccessKey;
    private final Optional<String> wasbStorageAccount;
    private final Optional<String> adlClientId;
    private final Optional<String> adlCredential;
    private final Optional<String> adlRefreshUrl;
    private final Optional<String> abfsAccessKey;
    private final Optional<String> abfsStorageAccount;
    private final Optional<String> abfsOAuthClientEndpoint;
    private final Optional<String> abfsOAuthClientId;
    private final Optional<String> abfsOAuthClientSecret;

    @Inject
    public TrinoAzureConfigurationInitializer(HiveAzureConfig config) {
        this.wasbAccessKey = TrinoAzureConfigurationInitializer.dropEmpty(config.getWasbAccessKey());
        this.wasbStorageAccount = TrinoAzureConfigurationInitializer.dropEmpty(config.getWasbStorageAccount());
        if (this.wasbAccessKey.isPresent() || this.wasbStorageAccount.isPresent()) {
            Preconditions.checkArgument((this.wasbAccessKey.isPresent() && this.wasbStorageAccount.isPresent() ? 1 : 0) != 0, (Object)"If WASB storage account or access key is set, both must be set");
        }
        this.abfsAccessKey = TrinoAzureConfigurationInitializer.dropEmpty(config.getAbfsAccessKey());
        this.abfsStorageAccount = TrinoAzureConfigurationInitializer.dropEmpty(config.getAbfsStorageAccount());
        if (this.abfsAccessKey.isPresent() || this.abfsStorageAccount.isPresent()) {
            Preconditions.checkArgument((this.abfsStorageAccount.isPresent() && this.abfsAccessKey.isPresent() ? 1 : 0) != 0, (Object)"If ABFS storage account or access key is set, both must be set");
        }
        this.adlClientId = TrinoAzureConfigurationInitializer.dropEmpty(config.getAdlClientId());
        this.adlCredential = TrinoAzureConfigurationInitializer.dropEmpty(config.getAdlCredential());
        this.adlRefreshUrl = TrinoAzureConfigurationInitializer.dropEmpty(config.getAdlRefreshUrl());
        if (this.adlClientId.isPresent() || this.adlCredential.isPresent() || this.adlRefreshUrl.isPresent()) {
            Preconditions.checkArgument((this.adlClientId.isPresent() && this.adlCredential.isPresent() && this.adlRefreshUrl.isPresent() ? 1 : 0) != 0, (Object)"If any of ADL client ID, credential, and refresh URL are set, all must be set");
        }
        this.abfsOAuthClientEndpoint = TrinoAzureConfigurationInitializer.dropEmpty(config.getAbfsOAuthClientEndpoint());
        this.abfsOAuthClientId = TrinoAzureConfigurationInitializer.dropEmpty(config.getAbfsOAuthClientId());
        this.abfsOAuthClientSecret = TrinoAzureConfigurationInitializer.dropEmpty(config.getAbfsOAuthClientSecret());
        if (this.abfsOAuthClientEndpoint.isPresent() || this.abfsOAuthClientSecret.isPresent() || this.abfsOAuthClientId.isPresent()) {
            Preconditions.checkArgument((this.abfsOAuthClientEndpoint.isPresent() && this.abfsOAuthClientId.isPresent() && this.abfsOAuthClientSecret.isPresent() ? 1 : 0) != 0, (Object)"If any of ABFS OAuth2 Client endpoint, ID, and secret are set, all must be set.");
        }
        Preconditions.checkArgument((!this.abfsAccessKey.isPresent() || !this.abfsOAuthClientSecret.isPresent() ? 1 : 0) != 0, (Object)"Multiple ABFS authentication methods configured: access key and OAuth2");
        config.getAdlProxyHost().ifPresent(proxyHost -> .HttpTransport.setConnectionProxy((Proxy)TrinoAzureConfigurationInitializer.proxyForHost(proxyHost)));
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        if (this.wasbAccessKey.isPresent() && this.wasbStorageAccount.isPresent()) {
            config.set(String.format("fs.azure.account.key.%s.blob.core.windows.net", this.wasbStorageAccount.get()), this.wasbAccessKey.get());
        }
        if (this.abfsAccessKey.isPresent() && this.abfsStorageAccount.isPresent()) {
            config.set(String.format("fs.azure.account.key.%s.dfs.core.windows.net", this.abfsStorageAccount.get()), this.abfsAccessKey.get());
            config.set("fs.abfs.impl", AzureBlobFileSystem.class.getName());
        }
        if (this.abfsOAuthClientEndpoint.isPresent() && this.abfsOAuthClientId.isPresent() && this.abfsOAuthClientSecret.isPresent()) {
            config.set("fs.azure.account.auth.type", "OAuth");
            config.set("fs.azure.account.oauth.provider.type", "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider");
            config.set("fs.azure.account.oauth2.client.endpoint", this.abfsOAuthClientEndpoint.get());
            config.set("fs.azure.account.oauth2.client.id", this.abfsOAuthClientId.get());
            config.set("fs.azure.account.oauth2.client.secret", this.abfsOAuthClientSecret.get());
        }
        if (this.adlClientId.isPresent() && this.adlCredential.isPresent() && this.adlRefreshUrl.isPresent()) {
            config.set("fs.adl.oauth2.access.token.provider.type", "ClientCredential");
            config.set("fs.adl.oauth2.client.id", this.adlClientId.get());
            config.set("fs.adl.oauth2.credential", this.adlCredential.get());
            config.set("fs.adl.oauth2.refresh.url", this.adlRefreshUrl.get());
            config.set("fs.adl.impl", AdlFileSystem.class.getName());
        }
        config.set("fs.azure.skipUserGroupMetadataDuringInitialization", "true");
        config.set("fs.azure.data.blocks.buffer", "array");
    }

    private static Optional<String> dropEmpty(Optional<String> optional) {
        return optional.filter(value -> !value.isEmpty());
    }

    private static Proxy proxyForHost(HostAndPort address) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(address.getHost(), address.getPort()));
    }
}

