/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.AbstractInputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.ByteArrayContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;

public class GcsAtomicOutputStream
extends ByteArrayOutputStream {
    private final Storage storage;
    private final Path path;
    private boolean closed;

    public GcsAtomicOutputStream(HdfsEnvironment environment, HdfsContext context, Path path) {
        this.storage = environment.createGcsStorage(context, path);
        this.path = path;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        StorageResourceId storageResourceId = StorageResourceId.fromStringPath((String)this.path.toString());
        Storage.Objects.Insert insert = this.storage.objects().insert(storageResourceId.getBucketName(), new StorageObject().setName(storageResourceId.getObjectName()), (AbstractInputStreamContent)new ByteArrayContent("application/octet-stream", this.buf, 0, this.count));
        insert.setIfGenerationMatch(Long.valueOf(0L));
        insert.getMediaHttpUploader().setDirectUploadEnabled(true);
        insert.execute();
    }
}

