/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import jakarta.annotation.Nullable;

public class HiveGcsConfig {
    private boolean useGcsAccessToken;
    private String jsonKey;
    private String jsonKeyFilePath;

    public boolean isUseGcsAccessToken() {
        return this.useGcsAccessToken;
    }

    @Config(value="hive.gcs.use-access-token")
    @ConfigDescription(value="Use client-provided OAuth token to access Google Cloud Storage")
    public HiveGcsConfig setUseGcsAccessToken(boolean useGcsAccessToken) {
        this.useGcsAccessToken = useGcsAccessToken;
        return this;
    }

    @Nullable
    public String getJsonKey() {
        return this.jsonKey;
    }

    @Config(value="hive.gcs.json-key")
    @ConfigSecuritySensitive
    public HiveGcsConfig setJsonKey(String jsonKey) {
        this.jsonKey = jsonKey;
        return this;
    }

    @Nullable
    @FileExists
    public String getJsonKeyFilePath() {
        return this.jsonKeyFilePath;
    }

    @Config(value="hive.gcs.json-key-file-path")
    @ConfigDescription(value="JSON key file used to access Google Cloud Storage")
    public HiveGcsConfig setJsonKeyFilePath(String jsonKeyFilePath) {
        this.jsonKeyFilePath = jsonKeyFilePath;
        return this;
    }

    public void validate() {
        if (this.useGcsAccessToken) {
            Preconditions.checkState((this.jsonKey == null ? 1 : 0) != 0, (Object)"Cannot specify 'hive.gcs.json-key' when 'hive.gcs.use-access-token' is set");
            Preconditions.checkState((this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"Cannot specify 'hive.gcs.json-key-file-path' when 'hive.gcs.use-access-token' is set");
        }
        Preconditions.checkState((this.jsonKey == null || this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"'hive.gcs.json-key' and 'hive.gcs.json-key-file-path' cannot be both set");
    }
}

