/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.s3;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.hdfs.s3.S3SecurityMappingConfig;
import io.trino.hdfs.s3.S3SecurityMappings;
import io.trino.hdfs.s3.S3SecurityMappingsParser;
import io.trino.hdfs.s3.S3SecurityMappingsProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;

public class FileBasedS3SecurityMappingsProvider
implements S3SecurityMappingsProvider {
    private static final Logger log = Logger.get(FileBasedS3SecurityMappingsProvider.class);
    private final File configFile;
    private final S3SecurityMappingsParser parser;

    @Inject
    public FileBasedS3SecurityMappingsProvider(S3SecurityMappingConfig config) {
        this.configFile = config.getConfigFilePath().map(File::new).orElseThrow(() -> new IllegalArgumentException("configFile not set"));
        if (!this.configFile.exists()) {
            throw new IllegalArgumentException(String.format("configFile %s does not exist", this.configFile.getAbsoluteFile()));
        }
        this.parser = new S3SecurityMappingsParser(config);
    }

    private String getRawJsonString() {
        log.info("Retrieving config from file %s", new Object[]{this.configFile});
        try {
            return Files.readString(this.configFile.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read file: " + String.valueOf(this.configFile), e);
        }
    }

    @Override
    public S3SecurityMappings get() {
        return this.parser.parseJSONString(this.getRawJsonString());
    }
}

