/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.ConfigPropertyMetadata;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemModule;
import io.trino.hdfs.HdfsModule;
import io.trino.hdfs.authentication.HdfsAuthenticationModule;
import io.trino.hdfs.azure.HiveAzureModule;
import io.trino.hdfs.cos.HiveCosModule;
import io.trino.hdfs.gcs.HiveGcsModule;
import io.trino.hdfs.s3.HiveS3Module;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.spi.NodeManager;
import io.trino.spi.catalog.CatalogName;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.weakref.jmx.guice.MBeanModule;

public final class HdfsFileSystemManager {
    private final Bootstrap bootstrap;
    private LifeCycleManager lifecycleManager;

    public HdfsFileSystemManager(Map<String, String> config, boolean azureEnabled, boolean gcsEnabled, boolean s3Enabled, String catalogName, NodeManager nodeManager, OpenTelemetry openTelemetry) {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(new MBeanModule());
        modules.add(new MBeanServerModule());
        modules.add(new ConnectorObjectNameGeneratorModule("", ""));
        modules.add(new HdfsFileSystemModule());
        modules.add(new HdfsModule());
        modules.add((Object)new HdfsAuthenticationModule());
        modules.add((Object)new HiveCosModule());
        modules.add(binder -> {
            binder.bind(NodeManager.class).toInstance((Object)nodeManager);
            binder.bind(OpenTelemetry.class).toInstance((Object)openTelemetry);
            binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
        });
        if (azureEnabled) {
            modules.add((Object)new HiveAzureModule());
        }
        if (gcsEnabled) {
            modules.add((Object)new HiveGcsModule());
        }
        if (s3Enabled) {
            modules.add((Object)new HiveS3Module());
        }
        this.bootstrap = new Bootstrap(modules).doNotInitializeLogging().setRequiredConfigurationProperties(Map.of()).setOptionalConfigurationProperties(config);
    }

    public Map<String, Boolean> configure() {
        return this.bootstrap.configure().stream().collect(Collectors.toMap(ConfigPropertyMetadata::name, ConfigPropertyMetadata::securitySensitive));
    }

    public TrinoFileSystemFactory create() {
        Preconditions.checkState((this.lifecycleManager == null ? 1 : 0) != 0, (Object)"Already created");
        Injector injector = this.bootstrap.initialize();
        this.lifecycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        return (TrinoFileSystemFactory)injector.getInstance(HdfsFileSystemFactory.class);
    }

    public void stop() {
        if (this.lifecycleManager != null) {
            this.lifecycleManager.stop();
        }
    }
}

