/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.cloud.hadoop.fs.gcs.TrinoGoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.gcs.HiveGcsConfig;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class GcsStorageFactory {
    private static final String APPLICATION_NAME = "Trino";
    private final boolean useGcsAccessToken;
    private final Optional<GoogleCredentials> jsonGoogleCredential;

    @Inject
    public GcsStorageFactory(HiveGcsConfig hiveGcsConfig) throws IOException {
        hiveGcsConfig.validate();
        this.useGcsAccessToken = hiveGcsConfig.isUseGcsAccessToken();
        String jsonKey = hiveGcsConfig.getJsonKey();
        String jsonKeyFilePath = hiveGcsConfig.getJsonKeyFilePath();
        if (jsonKey != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonKey.getBytes(StandardCharsets.UTF_8));){
                this.jsonGoogleCredential = Optional.of(GoogleCredentials.fromStream((InputStream)inputStream).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"}));
            }
        } else if (jsonKeyFilePath != null) {
            try (FileInputStream inputStream = new FileInputStream(jsonKeyFilePath);){
                this.jsonGoogleCredential = Optional.of(GoogleCredentials.fromStream((InputStream)inputStream).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"}));
            }
        } else {
            this.jsonGoogleCredential = Optional.empty();
        }
    }

    public Storage create(HdfsEnvironment environment, HdfsContext context, Path path) {
        try {
            GoogleCredentials credential;
            GoogleCloudStorageOptions gcsOptions = TrinoGoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(environment.getConfiguration(context, path)).build();
            HttpTransport httpTransport = HttpTransportFactory.createHttpTransport((String)gcsOptions.getProxyAddress(), (RedactedString)gcsOptions.getProxyUsername(), (RedactedString)gcsOptions.getProxyPassword());
            if (this.useGcsAccessToken) {
                String accessToken = Strings.nullToEmpty((String)((String)context.getIdentity().getExtraCredentials().get("hive.gcs.oauth")));
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(accessToken.getBytes(StandardCharsets.UTF_8));){
                    credential = GoogleCredentials.fromStream((InputStream)inputStream).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
                }
            } else {
                credential = this.jsonGoogleCredential.orElseThrow(() -> new IllegalStateException("GCS credentials not configured"));
            }
            return new Storage.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new RetryHttpInitializer((Credentials)credential, RetryHttpInitializerOptions.builder().setReadTimeout(gcsOptions.getHttpRequestReadTimeout()).setMaxRequestRetries(gcsOptions.getMaxHttpRequestRetries()).build())).setApplicationName(APPLICATION_NAME).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

