/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import com.google.common.base.Preconditions;
import io.airlift.compress.hadoop.HadoopStreams;
import io.airlift.slice.Slice;
import io.trino.hive.formats.compression.BufferedOutputStreamSliceOutput;
import io.trino.hive.formats.compression.ChunkedSliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public final class MemoryCompressedSliceOutput
extends BufferedOutputStreamSliceOutput {
    private final HadoopStreams hadoopStreams;
    private final ChunkedSliceOutput bufferedOutput;
    private boolean closed;
    private boolean destroyed;

    MemoryCompressedSliceOutput(HadoopStreams hadoopStreams, int minChunkSize, int maxChunkSize) throws IOException {
        this(hadoopStreams, new ChunkedSliceOutput(minChunkSize, maxChunkSize));
    }

    private MemoryCompressedSliceOutput(HadoopStreams hadoopStreams, ChunkedSliceOutput bufferedOutput) throws IOException {
        super((OutputStream)((Object)(hadoopStreams == null ? bufferedOutput : hadoopStreams.createOutputStream((OutputStream)((Object)bufferedOutput)))));
        this.hadoopStreams = hadoopStreams;
        this.bufferedOutput = Objects.requireNonNull(bufferedOutput, "bufferedOutput is null");
    }

    @Override
    public long getRetainedSize() {
        return super.getRetainedSize() + this.bufferedOutput.getRetainedSize();
    }

    public int getCompressedSize() {
        Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
        return this.bufferedOutput.size();
    }

    public List<Slice> getCompressedSlices() {
        Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
        return this.bufferedOutput.getSlices();
    }

    public MemoryCompressedSliceOutput createRecycledCompressedSliceOutput() throws IOException {
        Preconditions.checkState((boolean)this.closed, (Object)"Stream has not been closed");
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Stream has been destroyed");
        this.destroyed = true;
        this.bufferedOutput.reset();
        return new MemoryCompressedSliceOutput(this.hadoopStreams, this.bufferedOutput);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
        }
    }

    public void destroy() throws IOException {
        if (!this.destroyed) {
            this.destroyed = true;
            this.close();
        }
    }

    public static MemoryCompressedSliceOutput createUncompressedMemorySliceOutput(int minChunkSize, int maxChunkSize) throws IOException {
        return new MemoryCompressedSliceOutput(null, new ChunkedSliceOutput(minChunkSize, maxChunkSize));
    }
}

