/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collections;
import java.util.List;

public class CsvSerializer
implements LineSerializer {
    private final List<Column> columns;
    private final byte separatorChar;
    private final byte quoteChar;
    private final int escapeChar;

    public CsvSerializer(List<Column> columns, byte separatorChar, byte quoteChar, byte escapeChar) {
        Preconditions.checkArgument(((long)columns.size() == columns.stream().mapToInt(Column::ordinal).distinct().count() ? 1 : 0) != 0, (String)"Columns cannot have duplicate ordinals: %s", columns);
        columns.forEach(column -> Preconditions.checkArgument((column.type() == VarcharType.VARCHAR ? 1 : 0) != 0, (String)"CSV only supports VARCHAR columns: %s", (Object)column));
        this.columns = ImmutableList.copyOf(columns);
        Preconditions.checkArgument((separatorChar >= 0 ? 1 : 0) != 0, (Object)String.format("Separator character must be 7-bit ASCII: %02x", separatorChar));
        Preconditions.checkArgument((quoteChar >= 0 ? 1 : 0) != 0, (Object)String.format("Quote character must be 7-bit ASCII: %02x", quoteChar));
        Preconditions.checkArgument((escapeChar >= 0 ? 1 : 0) != 0, (Object)String.format("Escape character must be 7-bit ASCII: %02x", escapeChar));
        Preconditions.checkArgument((separatorChar != 0 ? 1 : 0) != 0, (Object)"Separator can not be the null character (ASCII 0)");
        Preconditions.checkArgument((separatorChar != quoteChar ? 1 : 0) != 0, (Object)"Separator and quote character can not be the same");
        Preconditions.checkArgument((separatorChar != escapeChar ? 1 : 0) != 0, (Object)"Separator and escape character can not be the same");
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
    }

    @Override
    public List<? extends Type> getTypes() {
        return Collections.nCopies(this.columns.size(), VarcharType.VARCHAR);
    }

    @Override
    public void write(Page page, int position, SliceOutput sliceOutput) {
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block;
            if (channel != 0) {
                sliceOutput.write((int)this.separatorChar);
            }
            if ((block = page.getBlock(channel)).isNull(position)) continue;
            sliceOutput.write((int)this.quoteChar);
            Slice value = VarcharType.VARCHAR.getSlice(block, position);
            if (value.indexOfByte(this.quoteChar) < 0 && (this.escapeChar == this.quoteChar || value.indexOfByte(this.escapeChar) < 0)) {
                sliceOutput.appendBytes(value);
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    byte c = value.getByte(i);
                    if (c == this.escapeChar || c == this.quoteChar) {
                        sliceOutput.appendByte(this.escapeChar);
                    }
                    sliceOutput.appendByte((int)c);
                }
            }
            sliceOutput.write((int)this.quoteChar);
        }
    }
}

