/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;

public class JsonSerializer
implements LineSerializer {
    private final RowType type;
    private final JsonFactory jsonFactory;

    public JsonSerializer(List<Column> columns) {
        this.type = RowType.from((List)((List)columns.stream().map(column -> RowType.field((String)column.name().toLowerCase(Locale.ROOT), (Type)column.type())).collect(ImmutableList.toImmutableList())));
        this.jsonFactory = new JsonFactory();
    }

    @Override
    public List<? extends Type> getTypes() {
        return this.type.getTypeParameters();
    }

    @Override
    public void write(Page page, int position, SliceOutput sliceOutput) throws IOException {
        try (JsonGenerator generator = this.jsonFactory.createGenerator((OutputStream)sliceOutput);){
            JsonSerializer.writeStruct(generator, this.type, arg_0 -> ((Page)page).getBlock(arg_0), position);
        }
    }

    private static void writeStruct(JsonGenerator generator, RowType rowType, IntFunction<Block> blocks, int position) throws IOException {
        generator.writeStartObject();
        List fields = rowType.getFields();
        for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
            RowType.Field field = (RowType.Field)fields.get(fieldIndex);
            generator.writeFieldName((String)field.getName().orElseThrow());
            Block block = blocks.apply(fieldIndex);
            JsonSerializer.writeValue(generator, field.getType(), block, position);
        }
        generator.writeEndObject();
    }

    private static void writeValue(JsonGenerator generator, Type type, Block block, int position) throws IOException {
        if (block.isNull(position)) {
            generator.writeNull();
            return;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            generator.writeBoolean(BooleanType.BOOLEAN.getBoolean(block, position));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            generator.writeNumber(BigintType.BIGINT.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            generator.writeNumber(IntegerType.INTEGER.getLong(block, position));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            generator.writeNumber(SmallintType.SMALLINT.getLong(block, position));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            generator.writeNumber(TinyintType.TINYINT.getLong(block, position));
        } else if (type instanceof DecimalType) {
            SqlDecimal value = (SqlDecimal)type.getObjectValue(null, block, position);
            generator.writeNumber(value.toBigDecimal().toString());
        } else if (RealType.REAL.equals((Object)type)) {
            generator.writeNumber(Float.intBitsToFloat((int)RealType.REAL.getLong(block, position)));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            generator.writeNumber(DoubleType.DOUBLE.getDouble(block, position));
        } else if (DateType.DATE.equals((Object)type)) {
            generator.writeString(HiveFormatUtils.formatHiveDate(block, position));
        } else if (type instanceof TimestampType) {
            generator.writeString(HiveFormatUtils.formatHiveTimestamp(type, block, position));
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            String value = type.getSlice(block, position).toStringUtf8();
            generator.writeString(value);
        } else if (type instanceof VarcharType) {
            generator.writeString(type.getSlice(block, position).toStringUtf8());
        } else if (type instanceof CharType) {
            CharType charType = (CharType)type;
            generator.writeString(Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8());
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            Block arrayBlock = arrayType.getObject(block, position);
            generator.writeStartArray();
            for (int arrayIndex = 0; arrayIndex < arrayBlock.getPositionCount(); ++arrayIndex) {
                JsonSerializer.writeValue(generator, elementType, arrayBlock, arrayIndex);
            }
            generator.writeEndArray();
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            Block mapBlock = mapType.getObject(block, position);
            generator.writeStartObject();
            for (int mapIndex = 0; mapIndex < mapBlock.getPositionCount(); mapIndex += 2) {
                generator.writeFieldName(JsonSerializer.toMapKey(keyType, mapBlock, mapIndex));
                JsonSerializer.writeValue(generator, valueType, mapBlock, mapIndex + 1);
            }
            generator.writeEndObject();
        } else if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List fields = rowType.getFields();
            Block rowBlock = rowType.getObject(block, position);
            generator.writeStartObject();
            for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
                RowType.Field field = (RowType.Field)fields.get(fieldIndex);
                generator.writeFieldName((String)field.getName().orElseThrow());
                JsonSerializer.writeValue(generator, field.getType(), rowBlock, fieldIndex);
            }
            generator.writeEndObject();
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private static String toMapKey(Type type, Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"map key is null");
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return String.valueOf(BooleanType.BOOLEAN.getBoolean(block, position));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return String.valueOf(BigintType.BIGINT.getLong(block, position));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return String.valueOf(IntegerType.INTEGER.getLong(block, position));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return String.valueOf(SmallintType.SMALLINT.getLong(block, position));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return String.valueOf(TinyintType.TINYINT.getLong(block, position));
        }
        if (type instanceof DecimalType) {
            return type.getObjectValue(null, block, position).toString();
        }
        if (RealType.REAL.equals((Object)type)) {
            return String.valueOf(Float.intBitsToFloat((int)RealType.REAL.getLong(block, position)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return String.valueOf(DoubleType.DOUBLE.getDouble(block, position));
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveFormatUtils.formatHiveDate(block, position);
        }
        if (type instanceof TimestampType) {
            return HiveFormatUtils.formatHiveTimestamp(type, block, position);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return type.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof VarcharType) {
            return type.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        throw new UnsupportedOperationException("Unsupported map key type: " + type);
    }
}

