/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.openxjson;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.DistinctMapKeys;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.openxjson.InvalidJsonException;
import io.trino.hive.formats.line.openxjson.JsonReader;
import io.trino.hive.formats.line.openxjson.JsonString;
import io.trino.hive.formats.line.openxjson.JsonWriter;
import io.trino.hive.formats.line.openxjson.OpenXJsonOptions;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.SingleRowBlockWriter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Base64;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.joda.time.DateTimeZone;

public final class OpenXJsonDeserializer
implements LineDeserializer {
    private final List<Type> types;
    private final OpenXJsonOptions options;
    private final RowDecoder rowDecoder;

    public OpenXJsonDeserializer(List<Column> columns, OpenXJsonOptions options) {
        this.options = Objects.requireNonNull(options, "options is null");
        this.types = (List)columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
        List timestampFormatters = (List)options.getTimestampFormats().stream().map(DateTimeFormatter::ofPattern).map(formatter -> formatter.withZone(ZoneOffset.UTC)).collect(ImmutableList.toImmutableList());
        this.rowDecoder = new RowDecoder(RowType.from((List)((List)columns.stream().map(column -> RowType.field((String)column.name().toLowerCase(Locale.ROOT), (Type)column.type())).collect(ImmutableList.toImmutableList()))), options, (List)columns.stream().map(Column::type).map(fieldType -> OpenXJsonDeserializer.createDecoder(fieldType, options, timestampFormatters)).collect(ImmutableList.toImmutableList()));
    }

    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void deserialize(LineBuffer lineBuffer, PageBuilder builder) throws IOException {
        Object jsonNode;
        block6: {
            String line = new String(lineBuffer.getBuffer(), 0, lineBuffer.getLength(), StandardCharsets.UTF_8).trim();
            jsonNode = null;
            if (line.startsWith("[") || line.startsWith("{")) {
                try {
                    jsonNode = JsonReader.readJson(line, originalValue -> new FieldName((String)originalValue, this.options.isCaseInsensitive(), this.options.isDotsInFieldNames(), (Map<String, String>)ImmutableMap.of()));
                }
                catch (InvalidJsonException e) {
                    if (this.options.isIgnoreMalformedJson()) break block6;
                    throw e;
                }
            }
        }
        if (jsonNode == null) {
            builder.declarePosition();
            for (int columnIndex = 0; columnIndex < this.types.size(); ++columnIndex) {
                builder.getBlockBuilder(columnIndex).appendNull();
            }
        } else {
            this.rowDecoder.decode(jsonNode, builder);
        }
    }

    private static Decoder createDecoder(Type type, OpenXJsonOptions options, List<DateTimeFormatter> timestampFormatters) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanDecoder();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new BigintDecoder();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return new IntegerDecoder();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return new SmallintDecoder();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return new TinyintDecoder();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalDecoder(decimalType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new RealDecoder();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleDecoder();
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateDecoder();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return new TimestampDecoder(timestampType, timestampFormatters);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new VarbinaryDecoder();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return new VarcharDecoder(varcharType);
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return new CharDecoder(charType);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayDecoder(OpenXJsonDeserializer.createDecoder(arrayType.getElementType(), options, timestampFormatters));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapDecoder(mapType, OpenXJsonDeserializer.createDecoder(mapType.getKeyType(), options, timestampFormatters), OpenXJsonDeserializer.createDecoder(mapType.getValueType(), options, timestampFormatters));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return new RowDecoder(rowType, options, (List)rowType.getFields().stream().map(RowType.Field::getType).map(fieldType -> OpenXJsonDeserializer.createDecoder(fieldType, options, timestampFormatters)).collect(ImmutableList.toImmutableList()));
        }
        throw new UnsupportedOperationException("Unsupported column type: " + type);
    }

    public static long parseLong(String stringValue) throws NumberFormatException, ArithmeticException {
        try {
            return OpenXJsonDeserializer.parseDecimalHexOctalLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigDecimal bigDecimal = new BigDecimal(stringValue).setScale(0, RoundingMode.DOWN);
            return bigDecimal.longValueExact();
        }
    }

    public static long parseDecimalHexOctalLong(String stringValue) throws NumberFormatException {
        if (OpenXJsonDeserializer.isHex(stringValue)) {
            return Long.parseLong(stringValue.substring(2), 16);
        }
        if (OpenXJsonDeserializer.isOctal(stringValue)) {
            return Long.parseLong(stringValue.substring(1), 8);
        }
        return Long.parseLong(stringValue);
    }

    private static boolean isHex(String s) {
        return s.length() >= 3 && s.charAt(0) == '0' && Character.toLowerCase(s.charAt(1)) == 'x' && HexFormat.isHexDigit(s.charAt(2));
    }

    private static boolean isOctal(String s) {
        return s.length() >= 2 && s.charAt(0) == '0' && OpenXJsonDeserializer.isOctalDigit(s.charAt(1));
    }

    private static boolean isOctalDigit(char c) {
        int digit = c - 48;
        return digit >= 0 && digit <= 8;
    }

    private static RuntimeException invalidJson(String message) {
        return new RuntimeException("Invalid JSON: " + message);
    }

    private static class RowDecoder
    extends Decoder {
        private final List<FieldName> fieldNames;
        private final List<Decoder> fieldDecoders;
        private final boolean dotsInKeyNames;

        public RowDecoder(RowType rowType, OpenXJsonOptions options, List<Decoder> fieldDecoders) {
            this.fieldNames = (List)rowType.getFields().stream().map(field -> (String)field.getName().orElseThrow()).map(fieldName -> fieldName.toLowerCase(Locale.ROOT)).map(originalValue -> new FieldName((String)originalValue, options)).collect(ImmutableList.toImmutableList());
            this.fieldDecoders = fieldDecoders;
            this.dotsInKeyNames = options.isDotsInFieldNames();
        }

        public void decode(Object jsonValue, PageBuilder builder) throws IOException {
            builder.declarePosition();
            this.decodeValue(jsonValue, arg_0 -> ((PageBuilder)builder).getBlockBuilder(arg_0));
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            SingleRowBlockWriter currentBuilder = (SingleRowBlockWriter)builder.beginBlockEntry();
            this.decodeValue(jsonValue, arg_0 -> ((SingleRowBlockWriter)currentBuilder).getFieldBlockBuilder(arg_0));
            builder.closeEntry();
        }

        private void decodeValue(Object jsonValue, IntFunction<BlockBuilder> fieldBuilders) {
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                this.decodeValueFromString(jsonString, fieldBuilders);
            } else if (jsonValue instanceof Map) {
                Map jsonObject = (Map)jsonValue;
                this.decodeValueFromMap(jsonObject, fieldBuilders);
            } else if (jsonValue instanceof List) {
                List jsonArray = (List)jsonValue;
                this.decodeValueFromList(jsonArray, fieldBuilders);
            } else {
                throw OpenXJsonDeserializer.invalidJson("Expected JSON object: " + jsonValue.getClass().getSimpleName());
            }
        }

        private void decodeValueFromString(JsonString jsonString, IntFunction<BlockBuilder> fieldBuilders) {
            if (!jsonString.value().trim().isEmpty()) {
                throw OpenXJsonDeserializer.invalidJson("Primitive can not be coerced to a ROW");
            }
            for (int i = 0; i < this.fieldDecoders.size(); ++i) {
                BlockBuilder blockBuilder = fieldBuilders.apply(i);
                blockBuilder.appendNull();
            }
        }

        private void decodeValueFromMap(Map<?, ?> jsonObject, IntFunction<BlockBuilder> fieldBuilders) {
            for (int i = 0; i < this.fieldDecoders.size(); ++i) {
                FieldName fieldName = this.fieldNames.get(i);
                Object fieldValue = null;
                if (jsonObject.containsKey(fieldName)) {
                    fieldValue = jsonObject.get(fieldName);
                } else if (this.dotsInKeyNames) {
                    for (Object key : jsonObject.keySet()) {
                        if (!fieldName.originalValueMatchesDottedFieldName((FieldName)key)) continue;
                        fieldValue = jsonObject.get(key);
                        break;
                    }
                }
                BlockBuilder blockBuilder = fieldBuilders.apply(i);
                if (fieldValue == null) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.fieldDecoders.get(i).decode(fieldValue, blockBuilder);
            }
        }

        private void decodeValueFromList(List<?> jsonArray, IntFunction<BlockBuilder> fieldBuilders) {
            for (int i = 0; i < this.fieldDecoders.size(); ++i) {
                Object fieldValue = jsonArray.size() > i ? jsonArray.get(i) : null;
                BlockBuilder blockBuilder = fieldBuilders.apply(i);
                if (fieldValue == null) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.fieldDecoders.get(i).decode(fieldValue, blockBuilder);
            }
        }
    }

    private static class BooleanDecoder
    extends Decoder {
        private BooleanDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            BooleanType.BOOLEAN.writeBoolean(builder, BooleanDecoder.parseBoolean(jsonValue));
        }

        private static boolean parseBoolean(Object jsonValue) {
            return Boolean.parseBoolean(jsonValue.toString());
        }
    }

    private static class BigintDecoder
    extends Decoder {
        private BigintDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a BIGINT".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                BigintType.BIGINT.writeLong(builder, OpenXJsonDeserializer.parseLong(jsonString.value()));
                return;
            }
            catch (ArithmeticException | NumberFormatException runtimeException) {
                builder.appendNull();
                return;
            }
        }
    }

    private static class IntegerDecoder
    extends Decoder {
        private IntegerDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to an INTEGER".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                long longValue = OpenXJsonDeserializer.parseLong(jsonString.value());
                if ((long)((int)longValue) == longValue) {
                    IntegerType.INTEGER.writeLong(builder, longValue);
                    return;
                }
            }
            catch (ArithmeticException | NumberFormatException runtimeException) {
                // empty catch block
            }
            builder.appendNull();
        }
    }

    private static class SmallintDecoder
    extends Decoder {
        private SmallintDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a SMALLINT".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                long longValue = OpenXJsonDeserializer.parseLong(jsonString.value());
                if ((long)((short)longValue) == longValue) {
                    SmallintType.SMALLINT.writeLong(builder, longValue);
                    return;
                }
            }
            catch (ArithmeticException | NumberFormatException runtimeException) {
                // empty catch block
            }
            builder.appendNull();
        }
    }

    private static class TinyintDecoder
    extends Decoder {
        private TinyintDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a TINYINT".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                long longValue = OpenXJsonDeserializer.parseLong(jsonString.value());
                if ((long)((byte)longValue) == longValue) {
                    TinyintType.TINYINT.writeLong(builder, longValue);
                    return;
                }
            }
            catch (ArithmeticException | NumberFormatException runtimeException) {
                // empty catch block
            }
            builder.appendNull();
        }
    }

    private static class DecimalDecoder
    extends Decoder {
        private final DecimalType decimalType;

        public DecimalDecoder(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a %s".formatted(jsonValue.getClass().getSimpleName(), this.decimalType));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                BigDecimal bigDecimal = HiveFormatUtils.scaleDecimal(new BigDecimal(jsonString.value()), this.decimalType);
                if (!Decimals.overflows((BigDecimal)bigDecimal, (long)this.decimalType.getPrecision())) {
                    if (this.decimalType.isShort()) {
                        this.decimalType.writeLong(builder, bigDecimal.unscaledValue().longValueExact());
                    } else {
                        this.decimalType.writeObject(builder, (Object)Int128.valueOf((BigInteger)bigDecimal.unscaledValue()));
                    }
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            builder.appendNull();
        }
    }

    private static class RealDecoder
    extends Decoder {
        private RealDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a REAL".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(Float.parseFloat(jsonString.value())));
            }
            catch (NumberFormatException ignored) {
                builder.appendNull();
            }
        }
    }

    private static class DoubleDecoder
    extends Decoder {
        private DoubleDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a DOUBLE".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                DoubleType.DOUBLE.writeDouble(builder, Double.parseDouble(jsonString.value()));
            }
            catch (NumberFormatException e) {
                builder.appendNull();
            }
        }
    }

    private static class DateDecoder
    extends Decoder {
        private DateDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a DATE".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            String dateString = jsonString.value();
            try {
                DateType.DATE.writeLong(builder, (long)StrictMath.toIntExact(HiveFormatUtils.parseHiveDate(dateString).toEpochDay()));
                return;
            }
            catch (ArithmeticException | DateTimeParseException runtimeException) {
                try {
                    DateType.DATE.writeLong(builder, (long)StrictMath.toIntExact(OpenXJsonDeserializer.parseDecimalHexOctalLong(dateString)));
                    return;
                }
                catch (ArithmeticException | NumberFormatException runtimeException2) {
                    builder.appendNull();
                    return;
                }
            }
        }
    }

    private static class TimestampDecoder
    extends Decoder {
        private final TimestampType timestampType;
        private final List<DateTimeFormatter> timestampFormatters;
        private final TrinoTimestampEncoder<? extends Comparable<?>> timestampEncoder;
        private static final int MIN_NUMERIC_TIMESTAMP_MILLIS_LENGTH = 13;
        private static final DateTimeFormatter ZONED_DATE_TIME_PARSER_NO_COLON = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HHMM", "Z").optionalEnd().toFormatter().withResolverStyle(ResolverStyle.LENIENT);
        private static final DateTimeFormatter ZONED_DATE_TIME_PARSER_WITH_COLON = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().toFormatter().withResolverStyle(ResolverStyle.LENIENT);
        private static final Pattern HAS_TZ_OFFSET = Pattern.compile(".+([+\\-])\\d{2}:?\\d{2}$");

        public TimestampDecoder(TimestampType timestampType, List<DateTimeFormatter> timestampFormatters) {
            this.timestampType = timestampType;
            this.timestampFormatters = timestampFormatters;
            this.timestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)timestampType, (DateTimeZone)DateTimeZone.UTC);
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a %s".formatted(jsonValue.getClass().getSimpleName(), this.timestampType));
            }
            JsonString jsonString = (JsonString)jsonValue;
            try {
                DecodedTimestamp timestamp = TimestampDecoder.parseTimestamp(jsonString.value(), this.timestampFormatters);
                this.timestampEncoder.write(timestamp, builder);
            }
            catch (ArithmeticException | NumberFormatException | DateTimeParseException e) {
                builder.appendNull();
            }
        }

        public static DecodedTimestamp parseTimestamp(String value, List<DateTimeFormatter> timestampFormatters) {
            for (DateTimeFormatter formatter : timestampFormatters) {
                try {
                    ZonedDateTime zonedDateTime = formatter.parse((CharSequence)value, ZonedDateTime::from);
                    long epochSeconds = zonedDateTime.toEpochSecond();
                    return new DecodedTimestamp(epochSeconds, zonedDateTime.getNano());
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            if (value.indexOf(58) > 0) {
                if (value.endsWith("z") || value.endsWith("Z") || HAS_TZ_OFFSET.matcher(value).matches()) {
                    try {
                        ZonedDateTime zonedDateTime = ZonedDateTime.parse(value, ZONED_DATE_TIME_PARSER_NO_COLON);
                        zonedDateTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC);
                        return new DecodedTimestamp(zonedDateTime.toEpochSecond(), zonedDateTime.getNano());
                    }
                    catch (DateTimeParseException zonedDateTime) {
                        try {
                            ZonedDateTime zonedDateTime2 = ZonedDateTime.parse(value, ZONED_DATE_TIME_PARSER_WITH_COLON);
                            zonedDateTime2 = zonedDateTime2.withZoneSameInstant(ZoneOffset.UTC);
                            return new DecodedTimestamp(zonedDateTime2.toEpochSecond(), zonedDateTime2.getNano());
                        }
                        catch (DateTimeParseException zonedDateTime2) {
                            // empty catch block
                        }
                    }
                }
                return HiveFormatUtils.parseHiveTimestamp(value);
            }
            if (!CharMatcher.anyOf((CharSequence)"-+.0123456789").matchesAllOf((CharSequence)value)) {
                throw new DateTimeParseException("Invalid timestamp", value, 0);
            }
            if (value.indexOf(46) >= 0) {
                long epochMillis = new BigDecimal(value).scaleByPowerOfTen(3).setScale(0, RoundingMode.DOWN).longValueExact();
                return TimestampDecoder.ofEpochMilli(epochMillis);
            }
            long timestampNumber = Long.parseLong(value);
            if (value.length() >= 13) {
                return TimestampDecoder.ofEpochMilli(timestampNumber);
            }
            return new DecodedTimestamp(timestampNumber, 0);
        }

        private static DecodedTimestamp ofEpochMilli(long epochMillis) {
            long epochSeconds = StrictMath.floorDiv(epochMillis, 1000L);
            long fractionalSecond = StrictMath.floorMod(epochMillis, 1000L);
            int nanosOfSecond = StrictMath.toIntExact(fractionalSecond * 1000000L);
            return new DecodedTimestamp(epochSeconds, nanosOfSecond);
        }
    }

    private static class VarbinaryDecoder
    extends Decoder {
        private VarbinaryDecoder() {
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (!(jsonValue instanceof JsonString)) {
                throw OpenXJsonDeserializer.invalidJson("%s can not be coerced to a VARBINARY".formatted(jsonValue.getClass().getSimpleName()));
            }
            JsonString jsonString = (JsonString)jsonValue;
            if (!jsonString.quoted()) {
                throw OpenXJsonDeserializer.invalidJson("Unquoted JSON string is not allowed for VARBINARY: " + jsonValue.getClass().getSimpleName());
            }
            Slice binaryValue = Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(jsonString.value()));
            VarbinaryType.VARBINARY.writeSlice(builder, binaryValue);
        }
    }

    private static class VarcharDecoder
    extends Decoder {
        private final VarcharType varcharType;

        public VarcharDecoder(VarcharType varcharType) {
            this.varcharType = varcharType;
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            String string;
            if (jsonValue instanceof Map) {
                Map jsonObject = (Map)jsonValue;
                string = JsonWriter.writeJsonObject(jsonObject);
            } else if (jsonValue instanceof List) {
                List jsonList = (List)jsonValue;
                string = JsonWriter.writeJsonArray(jsonList);
            } else {
                JsonString jsonString = (JsonString)jsonValue;
                string = JsonWriter.canonicalizeJsonString(jsonString);
            }
            this.varcharType.writeSlice(builder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)string), (VarcharType)this.varcharType));
        }
    }

    private static class CharDecoder
    extends Decoder {
        private final CharType charType;

        public CharDecoder(CharType charType) {
            this.charType = charType;
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            String string;
            if (jsonValue instanceof Map) {
                Map jsonObject = (Map)jsonValue;
                string = JsonWriter.writeJsonObject(jsonObject);
            } else if (jsonValue instanceof List) {
                List jsonList = (List)jsonValue;
                string = JsonWriter.writeJsonArray(jsonList);
            } else {
                JsonString jsonString = (JsonString)jsonValue;
                string = JsonWriter.canonicalizeJsonString(jsonString);
            }
            this.charType.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)string), (CharType)this.charType));
        }
    }

    private static class ArrayDecoder
    extends Decoder {
        private final Decoder elementDecoder;

        public ArrayDecoder(Decoder elementDecoder) {
            this.elementDecoder = elementDecoder;
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            JsonString stingValue;
            if (jsonValue instanceof JsonString && (stingValue = (JsonString)jsonValue).value().isEmpty()) {
                builder.appendNull();
                return;
            }
            BlockBuilder elementBuilder = builder.beginBlockEntry();
            if (jsonValue instanceof List) {
                List jsonArray = (List)jsonValue;
                for (Object element : jsonArray) {
                    this.elementDecoder.decode(element, elementBuilder);
                }
            } else {
                this.elementDecoder.decode(jsonValue, elementBuilder);
            }
            builder.closeEntry();
        }
    }

    private static abstract class Decoder {
        private Decoder() {
        }

        public final void decode(Object jsonValue, BlockBuilder builder) {
            if (jsonValue == null) {
                builder.appendNull();
                return;
            }
            this.decodeValue(jsonValue, builder);
        }

        abstract void decodeValue(Object var1, BlockBuilder var2);
    }

    private static class MapDecoder
    extends Decoder {
        private final Decoder keyDecoder;
        private final Decoder valueDecoder;
        private final Type keyType;
        private final DistinctMapKeys distinctMapKeys;
        private BlockBuilder keyBlockBuilder;

        public MapDecoder(MapType mapType, Decoder keyDecoder, Decoder valueDecoder) {
            this.keyType = mapType.getKeyType();
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
            this.distinctMapKeys = new DistinctMapKeys(mapType, true);
            this.keyBlockBuilder = mapType.getKeyType().createBlockBuilder(null, 128);
        }

        @Override
        void decodeValue(Object jsonValue, BlockBuilder builder) {
            if (jsonValue instanceof JsonString) {
                JsonString jsonString = (JsonString)jsonValue;
                if (!jsonString.value().trim().isEmpty()) {
                    throw OpenXJsonDeserializer.invalidJson("Primitive can not be coerced to a MAP");
                }
                builder.appendNull();
                return;
            }
            Preconditions.checkArgument((boolean)(jsonValue instanceof Map), (String)"%s can not be coerced to a MAP", (Object)jsonValue.getClass().getSimpleName());
            Map jsonObject = (Map)jsonValue;
            Set fieldNames = jsonObject.keySet();
            Block keyBlock = this.readKeys(fieldNames);
            boolean[] distinctKeys = this.distinctMapKeys.selectDistinctKeys(keyBlock);
            BlockBuilder entryBuilder = builder.beginBlockEntry();
            int keyIndex = 0;
            for (Object fieldName : fieldNames) {
                if (distinctKeys[keyIndex]) {
                    this.keyType.appendTo(keyBlock, keyIndex, entryBuilder);
                    this.valueDecoder.decode(jsonObject.get(fieldName), entryBuilder);
                }
                ++keyIndex;
            }
            builder.closeEntry();
        }

        private Block readKeys(Collection<?> fieldNames) {
            for (Object fieldName : fieldNames) {
                JsonString jsonValue = new JsonString(fieldName.toString(), true);
                this.keyDecoder.decode(jsonValue, this.keyBlockBuilder);
            }
            Block keyBlock = this.keyBlockBuilder.build();
            this.keyBlockBuilder = this.keyType.createBlockBuilder(null, keyBlock.getPositionCount());
            return keyBlock;
        }
    }

    private static final class FieldName {
        private final String originalValue;
        private final String mappedName;
        private final boolean caseInsensitive;
        private final int hashCode;
        private final boolean canMatchDottedFieldName;
        private final boolean isDottedFieldName;

        public FieldName(String originalValue, OpenXJsonOptions options) {
            this(originalValue, options.isCaseInsensitive(), options.isDotsInFieldNames(), options.getFieldNameMappings());
        }

        public FieldName(String originalValue, boolean caseInsensitive, boolean dotsInFieldNames, Map<String, String> fieldNameMappings) {
            this.originalValue = Objects.requireNonNull(originalValue, "originalValue is null");
            this.mappedName = fieldNameMappings.getOrDefault(originalValue, originalValue);
            this.caseInsensitive = caseInsensitive;
            this.hashCode = caseInsensitive ? this.mappedName.toLowerCase(Locale.ROOT).hashCode() : this.mappedName.hashCode();
            this.canMatchDottedFieldName = dotsInFieldNames && originalValue.indexOf(95) >= 0;
            this.isDottedFieldName = dotsInFieldNames && originalValue.indexOf(46) >= 0;
        }

        public boolean originalValueMatchesDottedFieldName(FieldName dottedName) {
            if (!this.canMatchDottedFieldName || !dottedName.isDottedFieldName) {
                return false;
            }
            String underscoreName = dottedName.originalValue.replace('.', '_');
            return this.caseInsensitive ? this.originalValue.equalsIgnoreCase(underscoreName) : this.originalValue.equals(underscoreName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldName that = (FieldName)o;
            return this.caseInsensitive ? this.mappedName.equalsIgnoreCase(that.mappedName) : this.mappedName.equals(that.mappedName);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.originalValue;
        }
    }
}

