/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.CountingInputStream;
import io.airlift.slice.SizeOf;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class TextLineReader
implements LineReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TextLineReader.class);
    private final CountingInputStream in;
    private final byte[] buffer;
    private final long inputEnd;
    private boolean firstRecord = true;
    private int bufferStart;
    private int bufferEnd;
    private int bufferPosition;
    private boolean closed;
    private long readTimeNanos;

    public TextLineReader(InputStream in, int bufferSize) throws IOException {
        this(in, bufferSize, 0L, Long.MAX_VALUE);
    }

    public TextLineReader(InputStream in, int bufferSize, long start, long length) throws IOException {
        Objects.requireNonNull(in, "in is null");
        Preconditions.checkArgument((bufferSize >= 16 ? 1 : 0) != 0, (Object)"bufferSize must be at least 16 bytes");
        Preconditions.checkArgument((bufferSize <= 0x40000000 ? 1 : 0) != 0, (Object)"bufferSize is greater than 1GB");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start is negative");
        Preconditions.checkArgument((length > 0L ? 1 : 0) != 0, (Object)"length must be at least one byte");
        this.in = new CountingInputStream(in);
        this.buffer = new byte[bufferSize];
        this.inputEnd = Math.addExact(start, length);
        if (start == 0L) {
            this.fillBuffer();
            if (this.bufferEnd >= 3 && this.buffer[0] == -17 && this.buffer[1] == -69 && this.buffer[2] == -65) {
                this.bufferStart = 3;
                this.bufferPosition = 3;
            }
        } else {
            this.in.skipNBytes(start);
            if (this.closed) {
                return;
            }
            this.skipLines(1);
            this.firstRecord = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.in.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.buffer);
    }

    public long getCurrentPosition() {
        int currentBufferSize = this.bufferEnd - this.bufferPosition;
        return this.in.getCount() - (long)currentBufferSize;
    }

    @Override
    public long getBytesRead() {
        return this.in.getCount();
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public boolean readLine(LineBuffer lineBuffer) throws IOException {
        lineBuffer.reset();
        if (this.getCurrentPosition() > this.inputEnd) {
            this.close();
            return false;
        }
        if (this.bufferPosition >= this.bufferEnd) {
            this.fillBuffer();
        }
        if (this.closed) {
            if (this.firstRecord && this.bufferEnd > 0) {
                this.firstRecord = false;
                return true;
            }
            return false;
        }
        while (!this.closed) {
            if (this.seekToStartOfLineTerminator()) {
                lineBuffer.write(this.buffer, this.bufferStart, this.bufferPosition - this.bufferStart);
                this.seekPastLineTerminator();
                this.firstRecord = false;
                return true;
            }
            Verify.verify((this.bufferPosition == this.bufferEnd ? 1 : 0) != 0, (String)"expected to be at the end of the buffer", (Object[])new Object[0]);
            lineBuffer.write(this.buffer, this.bufferStart, this.bufferPosition - this.bufferStart);
            this.fillBuffer();
        }
        this.firstRecord = false;
        return !lineBuffer.isEmpty();
    }

    public void skipLines(int lineCount) throws IOException {
        Preconditions.checkArgument((lineCount >= 0 ? 1 : 0) != 0, (Object)"lineCount is negative");
        while (!this.closed && lineCount > 0) {
            if (this.getCurrentPosition() > this.inputEnd) {
                this.close();
                return;
            }
            this.firstRecord = false;
            if (this.bufferPosition >= this.bufferEnd) {
                this.fillBuffer();
                if (this.closed) {
                    return;
                }
            }
            if (!this.seekToStartOfLineTerminator()) continue;
            this.seekPastLineTerminator();
            --lineCount;
        }
    }

    private boolean seekToStartOfLineTerminator() {
        while (this.bufferPosition < this.bufferEnd) {
            if (TextLineReader.isEndOfLineCharacter(this.buffer[this.bufferPosition])) {
                return true;
            }
            ++this.bufferPosition;
        }
        return false;
    }

    private static boolean isEndOfLineCharacter(byte currentByte) {
        return currentByte == 10 || currentByte == 13;
    }

    private void seekPastLineTerminator() throws IOException {
        Verify.verify((boolean)TextLineReader.isEndOfLineCharacter(this.buffer[this.bufferPosition]), (String)"Stream is not at a line terminator", (Object[])new Object[0]);
        if (this.buffer[this.bufferPosition] == 13) {
            ++this.bufferPosition;
            if (this.bufferPosition >= this.bufferEnd) {
                this.fillBuffer();
                if (this.closed) {
                    return;
                }
            }
        }
        if (this.buffer[this.bufferPosition] == 10) {
            ++this.bufferPosition;
        }
        this.bufferStart = this.bufferPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBuffer() throws IOException {
        if (this.closed) {
            return;
        }
        Verify.verify((this.bufferPosition >= this.bufferEnd ? 1 : 0) != 0, (String)"Buffer is not empty", (Object[])new Object[0]);
        this.bufferStart = 0;
        this.bufferPosition = 0;
        this.bufferEnd = 0;
        long start = System.nanoTime();
        try {
            this.bufferEnd = this.in.readNBytes(this.buffer, 0, this.buffer.length);
        }
        finally {
            long duration = System.nanoTime() - start;
            this.readTimeNanos += duration;
        }
        if (this.bufferEnd == 0) {
            this.close();
        }
    }
}

