/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.text.BlockEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.List;

public class StructEncoding
extends BlockEncoding {
    private final byte separator;
    private final boolean lastColumnTakesRest;
    private final List<TextColumnEncoding> structFields;

    public StructEncoding(Type type, Slice nullSequence, byte separator, Byte escapeByte, boolean lastColumnTakesRest, List<TextColumnEncoding> structFields) {
        super(type, nullSequence, escapeByte);
        this.separator = separator;
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.structFields = structFields;
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) throws FileCorruptionException {
        Block row = (Block)block.getObject(position, Block.class);
        for (int fieldIndex = 0; fieldIndex < this.structFields.size(); ++fieldIndex) {
            if (fieldIndex > 0) {
                output.writeByte((int)this.separator);
            }
            if (row.isNull(fieldIndex)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.structFields.get(fieldIndex).encodeValueInto(row, fieldIndex, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        int end = offset + length;
        BlockBuilder structBuilder = builder.beginBlockEntry();
        int elementOffset = offset;
        int fieldIndex = 0;
        while (offset < end) {
            byte currentByte = slice.getByte(offset);
            if (currentByte == this.separator) {
                this.decodeElementValueInto(fieldIndex, structBuilder, slice, elementOffset, offset - elementOffset);
                elementOffset = offset + 1;
                if (this.lastColumnTakesRest && ++fieldIndex == this.structFields.size() - 1) break;
                if (fieldIndex == this.structFields.size()) {
                    builder.closeEntry();
                    return;
                }
            } else if (this.isEscapeByte(currentByte)) {
                ++offset;
            }
            ++offset;
        }
        this.decodeElementValueInto(fieldIndex, structBuilder, slice, elementOffset, end - elementOffset);
        ++fieldIndex;
        while (fieldIndex < this.structFields.size()) {
            structBuilder.appendNull();
            ++fieldIndex;
        }
        builder.closeEntry();
    }

    private void decodeElementValueInto(int fieldIndex, BlockBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        if (fieldIndex >= this.structFields.size()) {
            return;
        }
        if (this.isNullSequence(slice, offset, length)) {
            builder.appendNull();
        } else {
            this.structFields.get(fieldIndex).decodeValueInto(builder, slice, offset, length);
        }
    }
}

